/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.util.concurrent.FutureFallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.DockerRequestException;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogReader;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.helios.Polling;
import com.spotify.helios.TemporaryPorts;
import com.spotify.helios.ZooKeeperTestManager;
import com.spotify.helios.ZooKeeperTestingServerManager;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.cli.CliMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.ThrottleState;
import com.spotify.helios.master.MasterMain;
import com.spotify.helios.servicescommon.DockerHost;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactory;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.system.LoggingTestWatcher;
import com.sun.jersey.api.client.ClientResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URI;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.curator.framework.CuratorFramework;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class SystemTestBase {
    private static final Logger log = LoggerFactory.getLogger(SystemTestBase.class);
    public static final int WAIT_TIMEOUT_SECONDS = 40;
    public static final int LONG_WAIT_SECONDS = 200;
    public static final int INTERNAL_PORT = 4444;
    public static final String BUSYBOX = "busybox";
    public static final List<String> IDLE_COMMAND = Arrays.asList("sh", "-c", "trap 'exit 0' SIGINT SIGTERM; while :; do sleep 1; done");
    public final String testTag = "test_" + Integer.toHexString(ThreadLocalRandom.current().nextInt());
    public final String testJobName = "job_" + this.testTag;
    public final String testJobVersion = "v" + Integer.toHexString(ThreadLocalRandom.current().nextInt());
    public static final DockerHost DOCKER_HOST = DockerHost.fromEnv();
    public static final String TEST_USER = "test-user";
    public static final String TEST_HOST = "test-host";
    public static final String TEST_MASTER = "test-master";
    @Rule
    public final TemporaryPorts temporaryPorts = TemporaryPorts.create();
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    @Rule
    public final TestRule watcher = new LoggingTestWatcher();
    private int masterPort;
    private int masterAdminPort;
    private String masterEndpoint;
    private boolean integrationMode;
    private Range<Integer> dockerPortRange;
    private final List<Service> services = Lists.newArrayList();
    private final List<HeliosClient> clients = Lists.newArrayList();
    private String testHost;
    private Path agentStateDirs;
    private String masterName;
    private ZooKeeperTestManager zk;
    protected static String zooKeeperNamespace = null;
    protected final String zkClusterId = String.valueOf(ThreadLocalRandom.current().nextInt(10000));

    @BeforeClass
    public static void staticSetup() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    @Before
    public void baseSetup() throws Exception {
        System.setProperty("user.name", TEST_USER);
        this.masterPort = this.temporaryPorts.localPort("helios master");
        this.masterAdminPort = this.temporaryPorts.localPort("helios master admin");
        String className = this.getClass().getName();
        if (className.endsWith("ITCase")) {
            this.masterEndpoint = (String)Preconditions.checkNotNull((Object)System.getenv("HELIOS_ENDPOINT"), (Object)"For integration tests, HELIOS_ENDPOINT *must* be set");
            this.integrationMode = true;
        } else if (className.endsWith("Test")) {
            this.integrationMode = false;
            this.masterEndpoint = "http://localhost:" + this.masterPort();
        } else {
            throw new RuntimeException("Test class' name must end in either 'Test' or 'ITCase'.");
        }
        this.zk = this.zooKeeperTestManager();
        this.listThreads();
        this.zk.ensure("/config");
        this.zk.ensure("/status");
        this.agentStateDirs = this.temporaryFolder.newFolder("helios-agents").toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void dockerSetup() throws Exception {
        int probePort;
        TemporaryPorts.AllocatedPort allocatedPort;
        String portRange = System.getenv("DOCKER_PORT_RANGE");
        if (portRange != null) {
            String[] parts = portRange.split(":", 2);
            this.dockerPortRange = Range.closedOpen((Comparable)Integer.valueOf(parts[0]), (Comparable)Integer.valueOf(parts[1]));
            allocatedPort = (TemporaryPorts.AllocatedPort)Polling.await((long)200L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<TemporaryPorts.AllocatedPort>(){

                @Override
                public TemporaryPorts.AllocatedPort call() throws Exception {
                    int port = ThreadLocalRandom.current().nextInt((Integer)SystemTestBase.this.dockerPortRange.lowerEndpoint(), (Integer)SystemTestBase.this.dockerPortRange.upperEndpoint());
                    return SystemTestBase.this.temporaryPorts.tryAcquire("docker-probe", port);
                }
            });
            probePort = allocatedPort.port();
        } else {
            this.dockerPortRange = this.temporaryPorts.localPortRange("docker", 10);
            probePort = (Integer)this.dockerPortRange().lowerEndpoint();
            allocatedPort = null;
        }
        try {
            this.assertDockerReachable(probePort);
        }
        finally {
            if (allocatedPort != null) {
                allocatedPort.release();
            }
        }
    }

    protected DockerClient getNewDockerClient() throws Exception {
        if (Strings.isNullOrEmpty((String)DOCKER_HOST.dockerCertPath())) {
            return new DefaultDockerClient(DOCKER_HOST.uri());
        }
        Path dockerCertPath = java.nio.file.Paths.get(DOCKER_HOST.dockerCertPath(), new String[0]);
        return new DefaultDockerClient(DOCKER_HOST.uri(), new DockerCertificates(dockerCertPath));
    }

    private void assertDockerReachable(final int probePort) throws Exception {
        try (final DockerClient docker = this.getNewDockerClient();){
            try {
                docker.inspectImage(BUSYBOX);
            }
            catch (ImageNotFoundException e) {
                docker.pull(BUSYBOX);
            }
            ContainerConfig config = ContainerConfig.builder().image(BUSYBOX).cmd(new String[]{"nc", "-p", "4711", "-lle", "cat"}).exposedPorts((Set)ImmutableSet.of((Object)"4711/tcp")).build();
            HostConfig hostConfig = HostConfig.builder().portBindings((Map)ImmutableMap.of((Object)"4711/tcp", Arrays.asList(PortBinding.of((String)"0.0.0.0", (int)probePort)))).build();
            ContainerCreation creation = docker.createContainer(config, this.testTag + "-probe");
            final String containerId = creation.id();
            docker.startContainer(containerId, hostConfig);
            Polling.await((long)5L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ContainerInfo info = docker.inspectContainer(containerId);
                    return info.state().running() != false ? Boolean.valueOf(true) : null;
                }
            });
            log.info("Verifying that docker containers are reachable");
            try {
                Polling.awaitUnchecked((long)5L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public Object call() throws Exception {
                        log.info("Probing: {}:{}", (Object)DOCKER_HOST.address(), (Object)probePort);
                        try (Socket ignored = new Socket(DOCKER_HOST.address(), probePort);){
                            Boolean bl = true;
                            return bl;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }
                });
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Please ensure that DOCKER_HOST is set to an address that where containers can be reached. If docker is running in a local VM, DOCKER_HOST must be set to the address of that VM. If docker can only be reached on a limited port range, set the environment variable DOCKER_PORT_RANGE=start:end");
            }
            docker.killContainer(containerId);
        }
    }

    protected ZooKeeperTestManager zooKeeperTestManager() {
        return new ZooKeeperTestingServerManager(zooKeeperNamespace);
    }

    @After
    public void baseTeardown() throws Exception {
        this.tearDownJobs();
        for (HeliosClient client : this.clients) {
            client.close();
        }
        this.clients.clear();
        for (Service service : this.services) {
            try {
                service.stopAsync();
            }
            catch (Exception e) {
                log.error("Uncaught exception", (Throwable)e);
            }
        }
        for (Service service : this.services) {
            try {
                service.awaitTerminated();
            }
            catch (Exception e) {
                log.error("Service failed", (Throwable)e);
            }
        }
        this.services.clear();
        try (DockerClient dockerClient = this.getNewDockerClient();){
            List containers = dockerClient.listContainers(new DockerClient.ListContainersParam[0]);
            block20: for (Container container : containers) {
                for (String name : container.names()) {
                    if (!name.contains(this.testTag)) continue;
                    try {
                        dockerClient.killContainer(container.id());
                    }
                    catch (DockerException e) {
                        e.printStackTrace();
                    }
                    continue block20;
                }
            }
        }
        catch (Exception e) {
            log.error("Docker client exception", (Throwable)e);
        }
        if (this.zk != null) {
            this.zk.close();
        }
        this.listThreads();
    }

    private void listThreads() {
        ThreadGroup tg;
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        TreeMap sorted = Maps.newTreeMap();
        for (Thread t : threads) {
            tg = t.getThreadGroup();
            if (!t.isAlive() || tg != null && tg.getName().equals("system")) continue;
            sorted.put(t.getName(), t);
        }
        log.info("= THREADS " + Strings.repeat((String)"=", (int)70));
        for (Thread t : sorted.values()) {
            tg = t.getThreadGroup();
            log.info("{}: \"{}\" ({}{})", new Object[]{t.getId(), t.getName(), tg == null ? "" : tg.getName() + " ", t.isDaemon() ? "daemon" : ""});
        }
        log.info(Strings.repeat((String)"=", (int)80));
    }

    protected void tearDownJobs() throws InterruptedException, ExecutionException {
        if (!this.isIntegration()) {
            return;
        }
        if (System.getenv("ITCASE_PRESERVE_JOBS") != null) {
            return;
        }
        ArrayList undeploys = Lists.newArrayList();
        HeliosClient c = this.defaultClient();
        Map jobs = (Map)c.jobs().get();
        for (JobId jobId : jobs.keySet()) {
            if (!jobId.toString().startsWith(this.testTag)) continue;
            JobStatus st = (JobStatus)c.jobStatus(jobId).get();
            Set hosts = st.getDeployments().keySet();
            for (String host : hosts) {
                log.info("Undeploying job " + jobId);
                undeploys.add(c.undeploy(jobId, host));
            }
        }
        Futures.allAsList((Iterable)undeploys);
        ArrayList deletes = Lists.newArrayList();
        for (JobId jobId : jobs.keySet()) {
            if (!jobId.toString().startsWith(this.testTag)) continue;
            log.info("Deleting job " + jobId);
            deletes.add(c.deleteJob(jobId));
        }
        Futures.allAsList((Iterable)deletes);
    }

    protected boolean isIntegration() {
        return this.integrationMode;
    }

    protected TemporaryPorts temporaryPorts() {
        return this.temporaryPorts;
    }

    protected ZooKeeperTestManager zk() {
        return this.zk;
    }

    protected String masterEndpoint() {
        return this.masterEndpoint;
    }

    protected String masterName() throws InterruptedException, ExecutionException {
        if (this.integrationMode) {
            if (this.masterName == null) {
                this.masterName = (String)((List)this.defaultClient().listMasters().get()).get(0);
            }
            return this.masterName;
        }
        return TEST_MASTER;
    }

    protected HeliosClient defaultClient() {
        return this.client(TEST_USER, this.masterEndpoint());
    }

    protected HeliosClient client(String user, String endpoint) {
        HeliosClient client = HeliosClient.newBuilder().setUser(user).setEndpoints(Arrays.asList(URI.create(endpoint))).build();
        this.clients.add(client);
        return client;
    }

    protected int masterPort() {
        return this.masterPort;
    }

    protected int masterAdminPort() {
        return this.masterAdminPort;
    }

    public Range<Integer> dockerPortRange() {
        return this.dockerPortRange;
    }

    protected String testHost() throws InterruptedException, ExecutionException {
        if (this.integrationMode) {
            if (this.testHost == null) {
                List hosts = (List)this.defaultClient().listHosts().get();
                this.testHost = (String)hosts.get(new SecureRandom().nextInt(hosts.size()));
            }
            return this.testHost;
        }
        return TEST_HOST;
    }

    protected List<String> setupDefaultMaster(String ... args) throws Exception {
        if (this.isIntegration()) {
            Preconditions.checkArgument((args.length == 0 ? 1 : 0) != 0, (Object)"cannot start default master in integration test with arguments passed");
            return null;
        }
        CuratorFramework curator = this.zk.curator();
        curator.newNamespaceAwareEnsurePath(Paths.configHosts()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.configJobs()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.configJobRefs()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.statusHosts()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.statusMasters()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.historyJobs()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.configId((String)this.zkClusterId)).ensure(curator.getZookeeperClient());
        ArrayList argsList = Lists.newArrayList((Object[])new String[]{"-vvvv", "--no-log-setup", "--http", this.masterEndpoint(), "--admin=" + this.masterAdminPort(), "--name", TEST_MASTER, "--domain", "", "--zk", this.zk.connectString()});
        argsList.addAll(Arrays.asList(args));
        return argsList;
    }

    protected void startDefaultMaster(String ... args) throws Exception {
        List<String> argsList = this.setupDefaultMaster(args);
        if (argsList == null) {
            return;
        }
        this.startMaster(argsList.toArray(new String[argsList.size()]));
        this.waitForMasterToConnectToZK();
    }

    protected void waitForMasterToConnectToZK() throws Exception {
        Polling.await((long)40L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    List masters = (List)SystemTestBase.this.defaultClient().listMasters().get();
                    return masters != null;
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    protected void startDefaultMasterDontWaitForZK(CuratorClientFactory curatorClientFactory, String ... args) throws Exception {
        List<String> argsList = this.setupDefaultMaster(args);
        if (argsList == null) {
            return;
        }
        this.startMaster(curatorClientFactory, argsList.toArray(new String[argsList.size()]));
    }

    protected AgentMain startDefaultAgent(String host, String ... args) throws Exception {
        if (this.isIntegration()) {
            Preconditions.checkArgument((args.length == 0 ? 1 : 0) != 0, (Object)"cannot start default agent in integration test with arguments passed");
            return null;
        }
        String stateDir = this.agentStateDirs.resolve(host).toString();
        ArrayList argsList = Lists.newArrayList((Object[])new String[]{"-vvvv", "--no-log-setup", "--no-http", "--name", host, "--docker=" + DOCKER_HOST, "--zk", this.zk.connectString(), "--zk-session-timeout", "100", "--zk-connection-timeout", "100", "--state-dir", stateDir, "--domain", "", "--port-range=" + this.dockerPortRange.lowerEndpoint() + ":" + this.dockerPortRange.upperEndpoint()});
        argsList.addAll(Arrays.asList(args));
        return this.startAgent(argsList.toArray(new String[argsList.size()]));
    }

    protected MasterMain startMaster(String ... args) throws Exception {
        MasterMain main = new MasterMain(args);
        main.startAsync().awaitRunning();
        this.services.add((Service)main);
        return main;
    }

    MasterMain startMaster(CuratorClientFactory curatorClientFactory, String ... args) throws Exception {
        MasterMain main = new MasterMain(curatorClientFactory, args);
        main.startAsync().awaitRunning();
        this.services.add((Service)main);
        return main;
    }

    protected AgentMain startAgent(String ... args) throws Exception {
        AgentMain main = new AgentMain(args);
        main.startAsync().awaitRunning();
        this.services.add((Service)main);
        return main;
    }

    protected JobId createJob(String name, String version, String image, List<String> command) throws Exception {
        return this.createJob(name, version, image, command, Job.EMPTY_ENV, Job.EMPTY_PORTS, Job.EMPTY_REGISTRATION);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, Date expires) throws Exception {
        return this.createJob(name, version, image, command, Job.EMPTY_ENV, Job.EMPTY_PORTS, Job.EMPTY_REGISTRATION, Job.EMPTY_GRACE_PERIOD, Job.EMPTY_VOLUMES, expires);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, ImmutableMap<String, String> env) throws Exception {
        return this.createJob(name, version, image, command, (Map<String, String>)env, Job.EMPTY_PORTS, Job.EMPTY_REGISTRATION);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, Map<String, String> env, Map<String, PortMapping> ports) throws Exception {
        return this.createJob(name, version, image, command, env, ports, Job.EMPTY_REGISTRATION);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, Map<String, String> env, Map<String, PortMapping> ports, Map<ServiceEndpoint, ServicePorts> registration) throws Exception {
        return this.createJob(name, version, image, command, env, ports, registration, Job.EMPTY_GRACE_PERIOD, Job.EMPTY_VOLUMES);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, Map<String, String> env, Map<String, PortMapping> ports, Map<ServiceEndpoint, ServicePorts> registration, Integer gracePeriod, Map<String, String> volumes) throws Exception {
        return this.createJob(name, version, image, command, env, ports, registration, gracePeriod, volumes, Job.EMPTY_EXPIRES);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, Map<String, String> env, Map<String, PortMapping> ports, Map<ServiceEndpoint, ServicePorts> registration, Integer gracePeriod, Map<String, String> volumes, Date expires) throws Exception {
        return this.createJob(Job.newBuilder().setName(name).setVersion(version).setImage(image).setCommand(command).setEnv(env).setPorts(ports).setRegistration(registration).setGracePeriod(gracePeriod).setVolumes(volumes).setExpires(expires).build());
    }

    protected JobId createJob(Job job) throws Exception {
        String name = job.getId().getName();
        String version = job.getId().getVersion();
        Preconditions.checkArgument((boolean)name.contains(this.testTag), (Object)"Job name must contain testTag to enable cleanup");
        ArrayList args = Lists.newArrayList((Object[])new String[]{"-q", name + ':' + version, job.getImage()});
        for (Map.Entry entry : job.getEnv().entrySet()) {
            args.add("--env=" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        for (Map.Entry entry : job.getPorts().entrySet()) {
            args.add("--port");
            String value = "" + ((PortMapping)entry.getValue()).getInternalPort();
            if (((PortMapping)entry.getValue()).getExternalPort() != null) {
                value = value + ":" + ((PortMapping)entry.getValue()).getExternalPort();
            }
            if (((PortMapping)entry.getValue()).getProtocol() != null) {
                value = value + "/" + ((PortMapping)entry.getValue()).getProtocol();
            }
            args.add((String)entry.getKey() + "=" + value);
        }
        for (Map.Entry entry : job.getRegistration().entrySet()) {
            ServiceEndpoint r = (ServiceEndpoint)entry.getKey();
            for (String portName : ((ServicePorts)entry.getValue()).getPorts().keySet()) {
                args.add("--register=" + (r.getProtocol() == null ? String.format("%s=%s", r.getName(), portName) : String.format("%s/%s=%s", r.getName(), r.getProtocol(), portName)));
            }
        }
        for (Map.Entry entry : job.getVolumes().entrySet()) {
            if (Strings.isNullOrEmpty((String)((String)entry.getKey()))) {
                args.add("--volume=" + (String)entry.getKey());
                continue;
            }
            args.add("--volume=" + (String)entry.getValue() + ":" + (String)entry.getKey());
        }
        if (job.getExpires() != null) {
            args.add("--expires=" + ISO8601Utils.format((Date)job.getExpires()));
        }
        args.add("--");
        args.addAll(job.getCommand());
        String createOutput = this.cli("create", args);
        String jobId = CharMatcher.WHITESPACE.trimFrom((CharSequence)createOutput);
        return JobId.fromString((String)jobId);
    }

    protected void deployJob(JobId jobId, String host) throws Exception {
        String deployOutput = this.cli("deploy", jobId.toString(), host);
        MatcherAssert.assertThat((Object)deployOutput, (Matcher)Matchers.containsString((String)(host + ": done")));
        String output = this.cli("status", "--host", host, "--json");
        Map statuses = (Map)Json.readUnchecked((String)output, (TypeReference)new TypeReference<Map<JobId, JobStatus>>(){});
        Assert.assertTrue((boolean)statuses.keySet().contains(jobId));
    }

    protected void undeployJob(JobId jobId, String host) throws Exception {
        String undeployOutput = this.cli("undeploy", jobId.toString(), host);
        MatcherAssert.assertThat((Object)undeployOutput, (Matcher)Matchers.containsString((String)(host + ": done")));
        String output = this.cli("status", "--host", host, "--json");
        Map statuses = (Map)Json.readUnchecked((String)output, (TypeReference)new TypeReference<Map<JobId, JobStatus>>(){});
        JobStatus status = (JobStatus)statuses.get(jobId);
        Assert.assertTrue((status == null || status.getDeployments().get(host) == null ? 1 : 0) != 0);
    }

    protected String startJob(JobId jobId, String host) throws Exception {
        return this.cli("start", jobId.toString(), host);
    }

    protected String stopJob(JobId jobId, String host) throws Exception {
        return this.cli("stop", jobId.toString(), host);
    }

    protected String deregisterHost(String host) throws Exception {
        return this.cli("deregister", host, "--force");
    }

    protected String cli(String command, Object ... args) throws Exception {
        return this.cli(command, this.flatten(args));
    }

    protected String cli(String command, String ... args) throws Exception {
        return this.cli(command, Arrays.asList(args));
    }

    protected String cli(String command, List<String> args) throws Exception {
        List<String> commands = Arrays.asList(command, "-z", this.masterEndpoint(), "--no-log-setup");
        ArrayList allArgs = Lists.newArrayList((Iterable)Iterables.concat(commands, args));
        return this.main(allArgs).toString();
    }

    protected ByteArrayOutputStream main(String ... args) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        CliMain main = new CliMain(new PrintStream(out), new PrintStream(err), args);
        main.run();
        return out;
    }

    protected ByteArrayOutputStream main(Collection<String> args) throws Exception {
        return this.main(args.toArray(new String[args.size()]));
    }

    protected void awaitHostRegistered(final String name, long timeout, TimeUnit timeUnit) throws Exception {
        Polling.await((long)timeout, (TimeUnit)timeUnit, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String output = SystemTestBase.this.cli("hosts", "-q");
                return output.contains(name) ? Boolean.valueOf(true) : null;
            }
        });
    }

    protected HostStatus awaitHostStatus(final String name, final HostStatus.Status status, int timeout, TimeUnit timeUnit) throws Exception {
        return (HostStatus)Polling.await((long)timeout, (TimeUnit)timeUnit, (Callable)new Callable<HostStatus>(){

            @Override
            public HostStatus call() throws Exception {
                Map statuses;
                String output = SystemTestBase.this.cli("hosts", name, "--json");
                try {
                    statuses = (Map)Json.read((String)output, (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
                }
                catch (IOException e) {
                    return null;
                }
                HostStatus hostStatus = (HostStatus)statuses.get(name);
                if (hostStatus == null) {
                    return null;
                }
                return hostStatus.getStatus() == status ? hostStatus : null;
            }
        });
    }

    protected TaskStatus awaitJobState(final HeliosClient client, final String host, final JobId jobId, final TaskStatus.State state, int timeout, TimeUnit timeunit) throws Exception {
        return (TaskStatus)Polling.await((long)timeout, (TimeUnit)timeunit, (Callable)new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                HostStatus hostStatus = (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
                if (hostStatus == null) {
                    return null;
                }
                TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
                return taskStatus != null && taskStatus.getState() == state ? taskStatus : null;
            }
        });
    }

    protected TaskStatus awaitJobThrottle(final HeliosClient client, final String host, final JobId jobId, final ThrottleState throttled, int timeout, TimeUnit timeunit) throws Exception {
        return (TaskStatus)Polling.await((long)timeout, (TimeUnit)timeunit, (Callable)new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                HostStatus hostStatus = (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
                if (hostStatus == null) {
                    return null;
                }
                TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
                return taskStatus != null && taskStatus.getThrottled() == throttled ? taskStatus : null;
            }
        });
    }

    protected void awaitHostRegistered(final HeliosClient client, final String host, int timeout, TimeUnit timeUnit) throws Exception {
        Polling.await((long)timeout, (TimeUnit)timeUnit, (Callable)new Callable<HostStatus>(){

            @Override
            public HostStatus call() throws Exception {
                return (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
            }
        });
    }

    protected HostStatus awaitHostStatus(final HeliosClient client, final String host, final HostStatus.Status status, int timeout, TimeUnit timeUnit) throws Exception {
        return (HostStatus)Polling.await((long)timeout, (TimeUnit)timeUnit, (Callable)new Callable<HostStatus>(){

            @Override
            public HostStatus call() throws Exception {
                HostStatus hostStatus = (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
                if (hostStatus == null) {
                    return null;
                }
                return hostStatus.getStatus() == status ? hostStatus : null;
            }
        });
    }

    protected TaskStatus awaitTaskState(final JobId jobId, final String host, final TaskStatus.State state) throws Exception {
        return (TaskStatus)Polling.await((long)200L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                Map statusMap;
                String output = SystemTestBase.this.cli("status", "--json", "--job", jobId.toString());
                try {
                    statusMap = (Map)Json.read((String)output, (TypeReference)new TypeReference<Map<JobId, JobStatus>>(){});
                }
                catch (IOException e) {
                    return null;
                }
                JobStatus status = (JobStatus)statusMap.get(jobId);
                if (status == null) {
                    return null;
                }
                TaskStatus taskStatus = (TaskStatus)status.getTaskStatuses().get(host);
                if (taskStatus == null) {
                    return null;
                }
                if (taskStatus.getState() != state) {
                    return null;
                }
                return taskStatus;
            }
        });
    }

    protected void awaitTaskGone(final HeliosClient client, final String host, final JobId jobId, long timeout, TimeUnit timeunit) throws Exception {
        Polling.await((long)timeout, (TimeUnit)timeunit, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                HostStatus hostStatus = (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
                TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
                Deployment deployment = (Deployment)hostStatus.getJobs().get(jobId);
                return taskStatus == null && deployment == null ? Boolean.valueOf(true) : null;
            }
        });
    }

    protected <T> T getOrNull(ListenableFuture<T> future) throws ExecutionException, InterruptedException {
        return (T)Futures.withFallback(future, (FutureFallback)new FutureFallback<T>(){

            public ListenableFuture<T> create(Throwable t) throws Exception {
                return Futures.immediateFuture(null);
            }
        }).get();
    }

    protected String readLogFully(ClientResponse logs) throws IOException {
        LogMessage logMessage;
        LogReader logReader = new LogReader(logs.getEntityInputStream());
        StringBuilder stringBuilder = new StringBuilder();
        while ((logMessage = logReader.nextMessage()) != null) {
            stringBuilder.append(Charsets.UTF_8.decode(logMessage.content()));
        }
        logReader.close();
        return stringBuilder.toString();
    }

    protected static void removeContainer(final DockerClient dockerClient, final String containerId) throws Exception {
        Polling.await((long)1L, (TimeUnit)TimeUnit.MINUTES, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    dockerClient.killContainer(containerId);
                    dockerClient.removeContainer(containerId);
                    return true;
                }
                catch (ContainerNotFoundException e) {
                    return true;
                }
                catch (DockerException e) {
                    if (e instanceof DockerRequestException && ((DockerRequestException)e).message().contains("Driver btrfs failed to remove root filesystem")) {
                        return true;
                    }
                    return null;
                }
            }
        });
        try {
            dockerClient.inspectContainer(containerId);
            Assert.fail();
        }
        catch (DockerException dockerException) {
            // empty catch block
        }
    }

    protected List<Container> listContainers(DockerClient dockerClient, String needle) throws DockerException, InterruptedException {
        List containers = dockerClient.listContainers(new DockerClient.ListContainersParam[0]);
        ArrayList matches = Lists.newArrayList();
        block0: for (Container container : containers) {
            if (container.names() == null) continue;
            for (String name : container.names()) {
                if (!name.contains(needle)) continue;
                matches.add(container);
                continue block0;
            }
        }
        return matches;
    }

    protected List<String> flatten(Object ... values) {
        List<Object> valuesList = Arrays.asList(values);
        return this.flatten(valuesList);
    }

    protected List<String> flatten(Iterable<?> values) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object value : values) {
            if (value instanceof Iterable) {
                list.addAll(this.flatten((Iterable)value));
                continue;
            }
            if (value.getClass() == String[].class) {
                list.addAll(Arrays.asList((String[])value));
                continue;
            }
            if (value instanceof String) {
                list.add((String)value);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return list;
    }

    protected void assertJobEquals(Job expected, Job actual) {
        Assert.assertEquals((Object)expected.toBuilder().setHash(actual.getId().getHash()).build(), (Object)actual);
    }
}

