/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableMap;
import com.spotify.helios.TemporaryPorts;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.HostDeregisterResponse;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.servicescommon.ZooKeeperRegistrarUtil;
import com.spotify.helios.servicescommon.coordination.DefaultZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.system.SystemTestBase;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DeregisterTest
extends SystemTestBase {
    @Rule
    public final TemporaryPorts ports = TemporaryPorts.create();

    @Test
    public void testDeregisterHostThatDoesntExist() throws Exception {
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        HeliosClient client = this.defaultClient();
        HostDeregisterResponse deregisterResponse = (HostDeregisterResponse)client.deregisterHost(host).get();
        Assert.assertEquals((Object)HostDeregisterResponse.Status.NOT_FOUND, (Object)deregisterResponse.getStatus());
    }

    @Test
    public void testDeregister() throws Exception {
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        AgentMain agent = this.startDefaultAgent(host, new String[0]);
        HeliosClient client = this.defaultClient();
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setPorts((Map)ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711), (Object)"bar", (Object)PortMapping.of((int)4712, (Integer)this.ports.localPort("bar")))).build();
        JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        this.awaitHostRegistered(client, host, 400, TimeUnit.SECONDS);
        this.awaitHostStatus(client, host, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, host).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        this.awaitJobState(client, host, jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        agent.stopAsync().awaitTerminated();
        HostDeregisterResponse deregisterResponse = (HostDeregisterResponse)client.deregisterHost(host).get();
        Assert.assertEquals((Object)HostDeregisterResponse.Status.OK, (Object)deregisterResponse.getStatus());
        JobDeleteResponse deleteResponse = (JobDeleteResponse)client.deleteJob(jobId).get();
        Assert.assertEquals((Object)JobDeleteResponse.Status.OK, (Object)deleteResponse.getStatus());
    }

    @Test
    public void testDeregisterJobDeployedWithoutStatus() throws Exception {
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        HeliosClient client = this.defaultClient();
        DefaultZooKeeperClient zkClient = new DefaultZooKeeperClient(this.zk().curatorWithSuperAuth());
        String idPath = Paths.configHostId((String)host);
        ZooKeeperRegistrarUtil.registerHost((ZooKeeperClient)zkClient, (String)idPath, (String)host, (String)UUID.randomUUID().toString());
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setPorts((Map)ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711), (Object)"bar", (Object)PortMapping.of((int)4712, (Integer)this.ports.localPort("bar")))).build();
        JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, host).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        HostDeregisterResponse deregisterResponse = (HostDeregisterResponse)client.deregisterHost(host).get();
        Assert.assertEquals((Object)HostDeregisterResponse.Status.OK, (Object)deregisterResponse.getStatus());
        JobDeleteResponse deleteResponse = (JobDeleteResponse)client.deleteJob(jobId).get();
        Assert.assertEquals((Object)JobDeleteResponse.Status.OK, (Object)deleteResponse.getStatus());
    }

    @Test
    public void testRegistrationResolution() throws Exception {
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        AgentMain agent = this.startDefaultAgent(host, "--labels", "num=1");
        HeliosClient client = this.defaultClient();
        this.awaitHostRegistered(client, host, 400, TimeUnit.SECONDS);
        this.awaitHostStatusWithHostInfo(client, host, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        agent.stopAsync().awaitTerminated();
        this.awaitHostStatus(client, host, HostStatus.Status.DOWN, 400, TimeUnit.SECONDS);
        this.resetAgentStateDir();
        this.startDefaultAgent(host, "--zk-registration-ttl", "0", "--labels", "num=2");
        this.awaitHostRegistered(client, host, 400, TimeUnit.SECONDS);
    }

    @Test(expected=TimeoutException.class)
    public void testRegistrationResolutionTtlNotExpired() throws Exception {
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        AgentMain agent = this.startDefaultAgent(host, new String[0]);
        HeliosClient client = this.defaultClient();
        this.awaitHostRegistered(client, host, 400, TimeUnit.SECONDS);
        this.awaitHostStatusWithHostInfo(client, host, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        agent.stopAsync().awaitTerminated();
        this.awaitHostStatus(client, host, HostStatus.Status.DOWN, 400, TimeUnit.SECONDS);
        this.resetAgentStateDir();
        try {
            this.startDefaultAgent(host, "--zk-registration-ttl", "9999");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.awaitHostStatus(client, host, HostStatus.Status.UP, 10, TimeUnit.SECONDS);
    }

    @Test
    public void testJobsArePreservedWhenReregistering() throws Exception {
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        AgentMain agent = this.startDefaultAgent(host, "--labels", "num=1");
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, host, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.deployJob(jobId, host);
        this.awaitJobState(client, host, jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        agent.stopAsync().awaitTerminated();
        this.awaitHostStatus(client, host, HostStatus.Status.DOWN, 400, TimeUnit.SECONDS);
        this.resetAgentStateDir();
        this.startDefaultAgent(host, "--zk-registration-ttl", "0", "--labels", "num=2");
        this.awaitHostRegistered(client, host, 400, TimeUnit.SECONDS);
        this.awaitHostStatusWithLabels(client, host, HostStatus.Status.UP, (Map<String, String>)ImmutableMap.of((Object)"num", (Object)"2"));
        this.awaitJobState(client, host, jobId, TaskStatus.State.RUNNING, 40, TimeUnit.SECONDS);
    }
}

