/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.system.SystemTestBase;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JobCreateTest
extends SystemTestBase {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testInvalidHostname() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        String output = this.createJobRawOutput(Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setHostname("$%^&").build());
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"Invalid hostname "));
    }

    @Test
    public void testPortMappingWithIp() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        this.createJobRawOutput(Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setPorts(Collections.singletonMap("foo", PortMapping.builder().ip("127.0.0.1").internalPort(80).externalPort(Integer.valueOf(80)).build())).build());
    }

    @Test
    public void testPortMappingWithBadIp() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("foobar is not a valid IP address.");
        this.createJobRawOutput(Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setPorts(Collections.singletonMap("foo", PortMapping.builder().ip("foobar").internalPort(80).externalPort(Integer.valueOf(80)).build())).build());
    }
}

