/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableSet;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class MultipleJobsTest
extends SystemTestBase {
    @Test
    public void jobStatusBulk() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostRegistered(this.testHost(), 400L, TimeUnit.SECONDS);
        HeliosClient client = this.defaultClient();
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        JobId jobId = job.getId();
        client.createJob(job).get();
        Job job2 = Job.newBuilder().setName(this.testJobName + "2").setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        JobId job2Id = job2.getId();
        client.createJob(job2).get();
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START, (String)"test-user");
        Deployment deployment2 = Deployment.of((JobId)job2Id, (Goal)Goal.START, (String)"test-user");
        client.deploy(deployment, this.testHost()).get();
        this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        client.deploy(deployment2, this.testHost()).get();
        this.awaitJobState(client, this.testHost(), job2Id, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        Map statuses = (Map)client.jobStatuses((Set)ImmutableSet.of((Object)jobId, (Object)job2Id)).get();
        Assert.assertTrue((String)"should contain job 1 id", (boolean)statuses.containsKey(jobId));
        Assert.assertTrue((String)"should contain job 2 id", (boolean)statuses.containsKey(job2Id));
    }
}

