/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.system.SystemTestBase;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ReapingTest
extends SystemTestBase {
    private final DockerClient docker = this.getNewDockerClient();

    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        String id = "test-" + Integer.toHexString(new SecureRandom().nextInt());
        String namespace = "helios-" + id;
        String intruder1 = this.intruder(namespace);
        String intruder2 = this.intruder(namespace);
        this.startContainer(intruder1);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--id=" + id);
        this.awaitHostRegistered(client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        String executionDriver = this.docker.info().executionDriver();
        List<Integer> expectedExitCodes = executionDriver != null && executionDriver.startsWith("lxc-") ? Collections.singletonList(0) : Arrays.asList(-1, 137);
        ContainerExit exit1 = this.docker.waitContainer(intruder1);
        Assert.assertThat((Object)exit1.statusCode(), (Matcher)Matchers.isIn(expectedExitCodes));
        this.startContainer(intruder2);
        ContainerExit exit2 = this.docker.waitContainer(intruder2);
        Assert.assertThat((Object)exit2.statusCode(), (Matcher)Matchers.isIn(expectedExitCodes));
    }

    private String intruder(String namespace) {
        return namespace + "-unwanted-" + Integer.toHexString(new SecureRandom().nextInt()) + "-" + this.testTag;
    }

    private void startContainer(String name) throws DockerException, InterruptedException {
        this.docker.pull("spotify/busybox:latest");
        HostConfig hostConfig = HostConfig.builder().build();
        ContainerConfig config = ContainerConfig.builder().image("spotify/busybox:latest").cmd(IDLE_COMMAND).hostConfig(hostConfig).build();
        ContainerCreation creation = this.docker.createContainer(config, name);
        String containerId = creation.id();
        this.docker.startContainer(containerId);
    }
}

