/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Container;
import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentTest
extends SystemTestBase {
    private static final JobId BOGUS_JOB = new JobId("bogus", "job", Strings.repeat((String)"0", (int)40));
    private static final String BOGUS_HOST = "BOGUS_HOST";
    private final int externalPort;

    public DeploymentTest() {
        this.externalPort = this.temporaryPorts.localPort("external");
    }

    @Test
    public void testLotsOfConcurrentJobs() throws Exception {
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostRegistered(client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        int numberOfJobs = 40;
        ArrayList jobIds = Lists.newArrayListWithCapacity((int)40);
        final String jobName = this.testJobName + "_" + Integer.toHexString(ThreadLocalRandom.current().nextInt());
        Integer i = 0;
        while (i < 40) {
            Object job = Job.newBuilder().setName(jobName).setVersion(i.toString()).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
            Object jobId = job.getId();
            CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
            Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
            Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START, (String)"test-user");
            JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
            Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
            jobIds.add(jobId);
            job = i;
            i = i + 1;
            jobId = i;
        }
        final HashSet containerIds = Sets.newHashSetWithExpectedSize((int)40);
        for (Object jobId : jobIds) {
            TaskStatus taskStatus = this.awaitJobState(client, this.testHost(), (JobId)jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
            containerIds.add(taskStatus.getContainerId());
        }
        try (final DockerClient dockerClient = this.getNewDockerClient();){
            for (String containerId : containerIds) {
                dockerClient.killContainer(containerId);
            }
            int restartedContainers = (Integer)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    int matchingContainerCount = 0;
                    for (Container c : dockerClient.listContainers(new DockerClient.ListContainersParam[0])) {
                        for (String name : c.names()) {
                            if (!name.contains(jobName)) continue;
                            ++matchingContainerCount;
                        }
                    }
                    if (matchingContainerCount < containerIds.size()) {
                        return null;
                    }
                    return matchingContainerCount;
                }
            });
            Assert.assertEquals((long)40L, (long)restartedContainers);
        }
    }

    @Test
    public void test() throws Exception {
        ImmutableMap ports = ImmutableMap.of((Object)"foos", (Object)PortMapping.of((int)17, (Integer)this.externalPort));
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setPorts((Map)ports).setCreatingUser("test-user").build();
        JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        CreateJobResponse duplicateJob = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.JOB_ALREADY_EXISTS, (Object)duplicateJob.getStatus());
        Map noMatchJobs = (Map)client.jobs(this.testJobName + "not_matching").get();
        Assert.assertTrue((boolean)noMatchJobs.isEmpty());
        Map matchJobs1 = (Map)client.jobs(this.testJobName).get();
        this.assertJobsEqual((Map<JobId, Job>)ImmutableMap.of((Object)jobId, (Object)job), matchJobs1);
        Map matchJobs2 = (Map)client.jobs(this.testJobName + ":" + this.testJobVersion).get();
        this.assertJobsEqual((Map<JobId, Job>)ImmutableMap.of((Object)jobId, (Object)job), matchJobs2);
        Map matchJobs3 = (Map)client.jobs(job.getId().toString()).get();
        this.assertJobsEqual((Map<JobId, Job>)ImmutableMap.of((Object)jobId, (Object)job), matchJobs3);
        this.awaitHostRegistered(client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START, (String)"test-user");
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        JobDeployResponse deployed2 = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.JOB_ALREADY_DEPLOYED, (Object)deployed2.getStatus());
        JobDeployResponse deployed3 = (JobDeployResponse)client.deploy(Deployment.of((JobId)BOGUS_JOB, (Goal)Goal.START), this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.JOB_NOT_FOUND, (Object)deployed3.getStatus());
        JobDeployResponse deployed4 = (JobDeployResponse)client.deploy(deployment, BOGUS_HOST).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.HOST_NOT_FOUND, (Object)deployed4.getStatus());
        JobUndeployResponse undeployResp = (JobUndeployResponse)client.undeploy(jobId, this.testHost()).get();
        Assert.assertEquals((Object)JobUndeployResponse.Status.OK, (Object)undeployResp.getStatus());
        JobDeployResponse redeployed = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)redeployed.getStatus());
        Deployment fetchedDeployment = (Deployment)client.deployment(this.testHost(), jobId).get();
        Assert.assertEquals((Object)deployment, (Object)fetchedDeployment);
        TaskStatus taskStatus = this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.assertJobEquals(job, taskStatus.getJob());
        Assert.assertEquals((Object)JobDeleteResponse.Status.STILL_IN_USE, (Object)((JobDeleteResponse)client.deleteJob(jobId).get()).getStatus());
        Thread.sleep(5000L);
        HostStatus hostStatus = (HostStatus)client.hostStatus(this.testHost()).get();
        taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
        Assert.assertEquals((String)jobId.toString(), (Object)TaskStatus.State.RUNNING, (Object)taskStatus.getState());
        JobUndeployResponse undeployed = (JobUndeployResponse)client.undeploy(jobId, this.testHost()).get();
        Assert.assertEquals((Object)JobUndeployResponse.Status.OK, (Object)undeployed.getStatus());
        Deployment undeployedJob = (Deployment)client.deployment(this.testHost(), jobId).get();
        Assert.assertTrue((undeployedJob == null ? 1 : 0) != 0);
        this.awaitTaskGone(client, this.testHost(), jobId, 400L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)JobDeleteResponse.Status.OK, (Object)((JobDeleteResponse)client.deleteJob(jobId).get()).getStatus());
        Assert.assertEquals((Object)JobDeleteResponse.Status.JOB_NOT_FOUND, (Object)((JobDeleteResponse)client.deleteJob(jobId).get()).getStatus());
    }

    @Test
    public void testJobWithDigest() throws Exception {
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox@sha256:16a2a52884c2a9481ed267c2d46483eac7693b813a63132368ab098a71303f8a").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        Map matchJobs = (Map)client.jobs(this.testJobName).get();
        this.assertJobsEqual((Map<JobId, Job>)ImmutableMap.of((Object)jobId, (Object)job), matchJobs);
        Assert.assertEquals((Object)"busybox@sha256:16a2a52884c2a9481ed267c2d46483eac7693b813a63132368ab098a71303f8a", (Object)((Job)matchJobs.get(jobId)).getImage());
        this.awaitHostRegistered(client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START, (String)"test-user");
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        TaskStatus taskStatus = this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.assertJobEquals(job, taskStatus.getJob());
    }
}

