/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DnsServerTest
extends SystemTestBase {
    @Test
    public void testDnsParam() throws Exception {
        String server1 = "127.0.0.1";
        String server2 = "127.0.0.2";
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), "--dns", "127.0.0.1", "--dns", "127.0.0.2");
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", Arrays.asList("cat", "/etc/resolv.conf"));
        this.deployJob(jobId, this.testHost());
        TaskStatus taskStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.EXITED);
        try (DockerClient dockerClient = this.getNewDockerClient();){
            LogStream logs = dockerClient.logs(taskStatus.getContainerId(), new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
            String log = logs.readFully();
            MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"127.0.0.1"));
            MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"127.0.0.2"));
        }
    }

    @Test
    public void testNoDnsParam() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", Arrays.asList("cat", "/etc/resolv.conf"));
        this.deployJob(jobId, this.testHost());
        TaskStatus taskStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.EXITED);
        try (DockerClient dockerClient = this.getNewDockerClient();){
            LogStream logs = dockerClient.logs(taskStatus.getContainerId(), new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
            String log = logs.readFully();
            MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"nameserver"));
        }
    }
}

