/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.master.ZooKeeperMasterModel;
import com.spotify.helios.servicescommon.coordination.DefaultZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import com.spotify.helios.servicescommon.coordination.ZooKeeperModelReporter;
import com.spotify.helios.system.SystemTestBase;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UndeployFilteringTest
extends SystemTestBase {
    private static final String TEST_HOST = "testhost";
    private CuratorFramework curator;
    private ZooKeeperMasterModel zkMasterModel;
    private AgentMain agent;
    private HeliosClient client;
    private final Job job;

    public UndeployFilteringTest() {
        this.job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).build();
    }

    @Before
    public void setUp() throws Exception {
        this.curator = this.zk().curatorWithSuperAuth();
        ZooKeeperClientProvider zkcp = new ZooKeeperClientProvider((ZooKeeperClient)new DefaultZooKeeperClient(this.curator), ZooKeeperModelReporter.noop());
        List eventSenders = Collections.emptyList();
        this.zkMasterModel = new ZooKeeperMasterModel(zkcp, this.getClass().getName(), eventSenders, "");
        this.startDefaultMaster(new String[0]);
        this.agent = this.startDefaultAgent(TEST_HOST, new String[0]);
        this.client = this.defaultClient();
        this.awaitHostRegistered(this.client, TEST_HOST, 400, TimeUnit.SECONDS);
    }

    @Test
    public void testMaster() throws Exception {
        JobId jobId = this.createAndAwaitJobRunning();
        this.agent.stopAsync().awaitTerminated();
        Assert.assertFalse((boolean)this.zkMasterModel.getJobs().isEmpty());
        Assert.assertEquals((Object)Goal.START, (Object)this.zkMasterModel.getDeployment(TEST_HOST, jobId).getGoal());
        this.client.undeploy(jobId, TEST_HOST).get();
        Assert.assertNull((Object)this.zkMasterModel.getDeployment(TEST_HOST, jobId));
        Assert.assertTrue((boolean)this.zkMasterModel.getHostStatus(TEST_HOST).getJobs().isEmpty());
    }

    @Test
    public void testAgent() throws Exception {
        JobId jobId = this.createAndAwaitJobRunning();
        byte[] data1 = (byte[])this.curator.getData().forPath(Paths.statusHostJob((String)TEST_HOST, (JobId)jobId));
        Assert.assertNotNull((Object)data1);
        TaskStatus status = (TaskStatus)Json.read((byte[])data1, TaskStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)Goal.START, (Object)status.getGoal());
        Assert.assertEquals((Object)TaskStatus.State.RUNNING, (Object)status.getState());
        this.agent.stopAsync().awaitTerminated();
        this.client.undeploy(jobId, TEST_HOST).get();
        byte[] data2 = (byte[])this.curator.getData().forPath(Paths.statusHostJob((String)TEST_HOST, (JobId)jobId));
        Assert.assertNotNull((Object)data2);
        TaskStatus status2 = (TaskStatus)Json.read((byte[])data2, TaskStatus.class);
        Assert.assertNotNull((Object)status2);
        Assert.assertEquals((Object)Goal.START, (Object)status2.getGoal());
        Assert.assertEquals((Object)TaskStatus.State.RUNNING, (Object)status2.getState());
    }

    private JobId createAndAwaitJobRunning() throws Exception {
        CreateJobResponse jobby = (CreateJobResponse)this.client.createJob(this.job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)jobby.getStatus());
        JobId jobId = this.job.getId();
        JobDeployResponse deployResponse = (JobDeployResponse)this.client.deploy(Deployment.of((JobId)jobId, (Goal)Goal.START), TEST_HOST).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployResponse.getStatus());
        this.awaitJobState(this.client, TEST_HOST, jobId, TaskStatus.State.RUNNING, 30, TimeUnit.SECONDS);
        return jobId;
    }
}

