/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.Maps;
import com.spotify.helios.Polling;
import com.spotify.helios.common.PomVersion;
import com.spotify.helios.system.SystemTestBase;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersionResponseFilterTest
extends SystemTestBase {
    private PomVersion current;

    @Before
    public void setUp() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.current = PomVersion.parse((String)"0.9.185");
        Polling.await((long)1L, (TimeUnit)TimeUnit.MINUTES, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return VersionResponseFilterTest.this.doVersionRequest(VersionResponseFilterTest.this.current.toString());
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    @Test
    public void testEqual() throws Exception {
        HttpURLConnection connection = this.doVersionRequest("0.9.185");
        this.assertResponseCodeType(connection, 2);
        this.assertServerVersion(connection);
        this.assertVersionStatus(connection, "EQUAL");
    }

    private void assertResponseCodeType(HttpURLConnection connection, int hc) throws IOException {
        Assert.assertEquals((long)hc, (long)(connection.getResponseCode() / 100));
    }

    @Test
    public void testMajorVersion() throws Exception {
        String newVersion = this.current.getMajor() + 1 + ".0.0";
        HttpURLConnection connection = this.doVersionRequest(newVersion);
        this.assertResponseCodeType(connection, 4);
        this.assertServerVersion(connection);
        this.assertVersionStatus(connection, "INCOMPATIBLE");
    }

    @Test
    public void testPatchVersion() throws Exception {
        String newVersion = this.current.getMajor() + "." + this.current.getMinor() + "." + (this.current.getPatch() + 1);
        HttpURLConnection connection = this.doVersionRequest(newVersion);
        this.assertResponseCodeType(connection, 2);
        this.assertServerVersion(connection);
        this.assertVersionStatus(connection, "COMPATIBLE");
    }

    @Test
    public void testMinorVersion() throws Exception {
        String newVersion = this.current.getMajor() + "." + (this.current.getMinor() + 1) + ".0";
        HttpURLConnection connection = this.doVersionRequest(newVersion);
        this.assertResponseCodeType(connection, 2);
        this.assertServerVersion(connection);
        this.assertVersionStatus(connection, "MAYBE");
    }

    @Test
    public void testMalformed() throws Exception {
        HttpURLConnection connection = this.doVersionRequest("deadbeef");
        this.assertResponseCodeType(connection, 4);
        this.assertServerVersion(connection);
        this.assertVersionStatus(connection, "INVALID");
    }

    @Test
    public void testMissing() throws Exception {
        HttpURLConnection connection = this.doVersionRequest(null);
        this.assertResponseCodeType(connection, 2);
        this.assertServerVersion(connection);
        this.assertVersionStatus(connection, "MISSING");
    }

    private void assertVersionStatus(HttpURLConnection connection, String status) {
        Assert.assertEquals((Object)status, (Object)connection.getHeaderField("Helios-Version-Status"));
    }

    private void assertServerVersion(HttpURLConnection connection) {
        Assert.assertEquals((Object)"0.9.185", (Object)connection.getHeaderField("Helios-Server-Version"));
    }

    private HttpURLConnection doVersionRequest(String version) throws IOException {
        HashMap headers = Maps.newHashMap();
        headers.put("Content-Type", Arrays.asList("application/json"));
        headers.put("Charset", Arrays.asList("utf-8"));
        if (version != null) {
            headers.put("Helios-Version", Arrays.asList(version));
        }
        URI uri = URI.create(this.masterEndpoint() + "/version");
        HttpURLConnection connection = this.connect(uri, headers);
        return connection;
    }

    private HttpURLConnection connect(URI uri, Map<String, List<String>> headers) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setInstanceFollowRedirects(false);
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            for (String value : header.getValue()) {
                connection.addRequestProperty(header.getKey(), value);
            }
        }
        connection.setRequestMethod("GET");
        connection.getResponseCode();
        return connection;
    }
}

