/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerCertificatesStore;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerHost;
import com.spotify.docker.client.exceptions.ContainerNotFoundException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.exceptions.DockerRequestException;
import com.spotify.docker.client.exceptions.ImageNotFoundException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.helios.Polling;
import com.spotify.helios.TemporaryPorts;
import com.spotify.helios.ZooKeeperTestManager;
import com.spotify.helios.ZooKeeperTestingServerManager;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.cli.CliMain;
import com.spotify.helios.cli.command.JobCreateCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.DeploymentGroupStatus;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.ThrottleState;
import com.spotify.helios.common.protocol.DeploymentGroupStatusResponse;
import com.spotify.helios.master.MasterMain;
import com.spotify.helios.servicescommon.ZooKeeperAclProviders;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactory;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.system.LoggingTestWatcher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class SystemTestBase {
    private static final Logger log = LoggerFactory.getLogger(SystemTestBase.class);
    public static final int WAIT_TIMEOUT_SECONDS = 40;
    public static final int LONG_WAIT_SECONDS = 400;
    public static final String BUSYBOX = "spotify/busybox:latest";
    public static final String BUSYBOX_WITH_DIGEST = "busybox@sha256:16a2a52884c2a9481ed267c2d46483eac7693b813a63132368ab098a71303f8a";
    public static final String NGINX = "spotify/nginx-alpine:latest";
    public static final String UHTTPD = "spotify/docker-uhttpd:latest";
    public static final String ALPINE = "spotify/alpine:latest";
    public static final String MEMCACHED = "spotify/memcached-mini:latest";
    public static final List<String> IDLE_COMMAND = Arrays.asList("sh", "-c", "trap 'exit 0' SIGINT SIGTERM; while :; do sleep 1; done");
    public final String testTag = "test_" + SystemTestBase.randomHexString();
    public final String testJobName = "job_" + this.testTag;
    public final String testJobVersion = "v" + SystemTestBase.randomHexString();
    public final String testJobNameAndVersion = this.testJobName + ":" + this.testJobVersion;
    public static final DockerHost DOCKER_HOST = DockerHost.fromEnv();
    public static final String TEST_USER = "test-user";
    public static final String TEST_HOST = "test-host";
    public static final String TEST_MASTER = "test-master";
    public static final String MASTER_USER = "helios-master";
    public static final String MASTER_PASSWORD = "master-password";
    public static final String AGENT_USER = "helios-agent";
    public static final String AGENT_PASSWORD = "agent-password";
    public static final String MASTER_DIGEST = ZooKeeperAclProviders.digest((String)"helios-master", (String)"master-password");
    public static final String AGENT_DIGEST = ZooKeeperAclProviders.digest((String)"helios-agent", (String)"agent-password");
    @Rule
    public final TemporaryPorts temporaryPorts = TemporaryPorts.create();
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    @Rule
    public final TestRule watcher = new LoggingTestWatcher();
    private int masterPort;
    private int masterAdminPort;
    private String masterEndpoint;
    private String masterAdminEndpoint;
    private Range<Integer> dockerPortRange;
    private final List<Service> services = Lists.newArrayList();
    private final List<HeliosClient> clients = Lists.newArrayList();
    private Path agentStateDirs;
    private Path masterStateDirs;
    private ZooKeeperTestManager zk;
    protected final String zkClusterId = String.valueOf(ThreadLocalRandom.current().nextInt(10000));
    protected CloseableHttpClient httpClient;

    @BeforeClass
    public static void staticSetup() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    @Before
    public void baseSetup() throws Exception {
        System.setProperty("user.name", TEST_USER);
        this.masterPort = this.temporaryPorts.localPort("helios master");
        this.masterAdminPort = this.temporaryPorts.localPort("helios master admin");
        this.masterEndpoint = "http://localhost:" + this.masterPort();
        this.masterAdminEndpoint = "http://localhost:" + this.masterAdminPort();
        this.zk = this.zooKeeperTestManager();
        this.listThreads();
        this.zk.ensure("/config");
        this.zk.ensure("/status");
        this.agentStateDirs = this.temporaryFolder.newFolder("helios-agents").toPath();
        this.masterStateDirs = this.temporaryFolder.newFolder("helios-masters").toPath();
        this.httpClient = HttpClients.createMinimal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void dockerSetup() throws Exception {
        int probePort;
        TemporaryPorts.AllocatedPort allocatedPort;
        String portRange = System.getenv("DOCKER_PORT_RANGE");
        if (portRange != null) {
            String[] parts = portRange.split(":", 2);
            this.dockerPortRange = Range.closedOpen((Comparable)Integer.valueOf(parts[0]), (Comparable)Integer.valueOf(parts[1]));
            allocatedPort = (TemporaryPorts.AllocatedPort)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<TemporaryPorts.AllocatedPort>(){

                @Override
                public TemporaryPorts.AllocatedPort call() throws Exception {
                    int port = ThreadLocalRandom.current().nextInt((Integer)SystemTestBase.this.dockerPortRange.lowerEndpoint(), (Integer)SystemTestBase.this.dockerPortRange.upperEndpoint());
                    return SystemTestBase.this.temporaryPorts.tryAcquire("docker-probe", port);
                }
            });
            probePort = allocatedPort.port();
        } else {
            this.dockerPortRange = this.temporaryPorts.localPortRange("docker", 10);
            probePort = (Integer)this.dockerPortRange().lowerEndpoint();
            allocatedPort = null;
        }
        try {
            this.assertDockerReachable(probePort);
        }
        finally {
            if (allocatedPort != null) {
                allocatedPort.release();
            }
        }
    }

    protected DockerClient getNewDockerClient() throws Exception {
        if (Strings.isNullOrEmpty((String)DOCKER_HOST.dockerCertPath())) {
            return new DefaultDockerClient(DOCKER_HOST.uri());
        }
        Path dockerCertPath = java.nio.file.Paths.get(DOCKER_HOST.dockerCertPath(), new String[0]);
        return new DefaultDockerClient(DOCKER_HOST.uri(), (DockerCertificatesStore)new DockerCertificates(dockerCertPath));
    }

    private void assertDockerReachable(final int probePort) throws Exception {
        try (final DockerClient docker = this.getNewDockerClient();){
            try {
                docker.inspectImage(BUSYBOX);
            }
            catch (ImageNotFoundException e) {
                docker.pull(BUSYBOX);
            }
            try {
                docker.inspectImage(ALPINE);
            }
            catch (ImageNotFoundException e) {
                docker.pull(ALPINE);
            }
            HostConfig hostConfig = HostConfig.builder().portBindings((Map)ImmutableMap.of((Object)"4711/tcp", Collections.singletonList(PortBinding.of((String)"0.0.0.0", (int)probePort)))).build();
            ContainerConfig config = ContainerConfig.builder().image(BUSYBOX).cmd(new String[]{"nc", "-p", "4711", "-lle", "cat"}).exposedPorts((Set)ImmutableSet.of((Object)"4711/tcp")).hostConfig(hostConfig).build();
            ContainerCreation creation = docker.createContainer(config, this.testTag + "-probe");
            final String containerId = creation.id();
            docker.startContainer(containerId);
            Polling.await((long)5L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ContainerInfo info = docker.inspectContainer(containerId);
                    return info.state().running() != false ? Boolean.valueOf(true) : null;
                }
            });
            log.info("Verifying that docker containers are reachable");
            try {
                Polling.awaitUnchecked((long)5L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public Object call() throws Exception {
                        log.info("Probing: {}:{}", (Object)DOCKER_HOST.address(), (Object)probePort);
                        try (Socket ignored = new Socket(DOCKER_HOST.address(), probePort);){
                            Boolean bl = true;
                            return bl;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }
                });
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Please ensure that DOCKER_HOST is set to an address that where containers can be reached. If docker is running in a local VM, DOCKER_HOST must be set to the address of that VM. If docker can only be reached on a limited port range, set the environment variable DOCKER_PORT_RANGE=start:end");
            }
            docker.killContainer(containerId);
        }
    }

    protected ZooKeeperTestManager zooKeeperTestManager() {
        return new ZooKeeperTestingServerManager();
    }

    @After
    public void baseTeardown() throws Exception {
        for (HeliosClient client : this.clients) {
            client.close();
        }
        this.clients.clear();
        for (Service service : this.services) {
            try {
                service.stopAsync();
            }
            catch (Exception e) {
                log.error("Uncaught exception", (Throwable)e);
            }
        }
        for (Service service : this.services) {
            try {
                service.awaitTerminated();
            }
            catch (Exception e) {
                log.error("Service failed", (Throwable)e);
            }
        }
        this.services.clear();
        try (DockerClient dockerClient = this.getNewDockerClient();){
            List containers = dockerClient.listContainers(new DockerClient.ListContainersParam[0]);
            block20: for (Container container : containers) {
                for (String name : container.names()) {
                    if (!name.contains(this.testTag)) continue;
                    try {
                        dockerClient.killContainer(container.id());
                    }
                    catch (DockerException e) {
                        e.printStackTrace();
                    }
                    continue block20;
                }
            }
        }
        catch (Exception e) {
            log.error("Docker client exception", (Throwable)e);
        }
        if (this.zk != null) {
            this.zk.close();
        }
        this.listThreads();
    }

    private void listThreads() {
        ThreadGroup tg;
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        TreeMap sorted = Maps.newTreeMap();
        for (Thread t : threads) {
            tg = t.getThreadGroup();
            if (!t.isAlive() || tg != null && tg.getName().equals("system")) continue;
            sorted.put(t.getName(), t);
        }
        log.info("= THREADS " + Strings.repeat((String)"=", (int)70));
        for (Thread t : sorted.values()) {
            tg = t.getThreadGroup();
            log.info("{}: \"{}\" ({}{})", new Object[]{t.getId(), t.getName(), tg == null ? "" : tg.getName() + " ", t.isDaemon() ? "daemon" : ""});
        }
        log.info(Strings.repeat((String)"=", (int)80));
    }

    protected TemporaryPorts temporaryPorts() {
        return this.temporaryPorts;
    }

    protected ZooKeeperTestManager zk() {
        return this.zk;
    }

    protected String masterEndpoint() {
        return this.masterEndpoint;
    }

    protected String masterAdminEndpoint() {
        return this.masterAdminEndpoint;
    }

    protected String masterName() throws InterruptedException, ExecutionException {
        return TEST_MASTER;
    }

    protected HeliosClient defaultClient() {
        return this.client(TEST_USER, this.masterEndpoint());
    }

    protected HeliosClient client(String user, String endpoint) {
        HeliosClient client = HeliosClient.newBuilder().setUser(user).setEndpoints(Collections.singletonList(URI.create(endpoint))).build();
        this.clients.add(client);
        return client;
    }

    protected int masterPort() {
        return this.masterPort;
    }

    protected int masterAdminPort() {
        return this.masterAdminPort;
    }

    public Range<Integer> dockerPortRange() {
        return this.dockerPortRange;
    }

    protected String testHost() throws InterruptedException, ExecutionException {
        return TEST_HOST;
    }

    protected List<String> setupDefaultMaster(String ... args) throws Exception {
        return this.setupDefaultMaster(0, args);
    }

    protected List<String> setupDefaultMaster(int offset, String ... args) throws Exception {
        String name;
        CuratorFramework curator = this.zk.curatorWithSuperAuth();
        curator.newNamespaceAwareEnsurePath(Paths.configHosts()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.configJobs()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.configJobRefs()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.statusHosts()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.statusMasters()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.historyJobs()).ensure(curator.getZookeeperClient());
        curator.newNamespaceAwareEnsurePath(Paths.configId((String)this.zkClusterId)).ensure(curator.getZookeeperClient());
        ArrayList argsList = Lists.newArrayList((Object[])new String[]{"-vvvv", "--no-log-setup", "--http", "http://0.0.0.0:" + (this.masterPort() + offset), "--admin", "http://0.0.0.0:" + (this.masterAdminPort() + offset), "--domain", "", "--zk", this.zk.connectString(), "--zk-enable-acls", "--zk-acl-agent-user", AGENT_USER, "--zk-acl-agent-digest", AGENT_DIGEST, "--zk-acl-master-user", MASTER_USER, "--zk-acl-master-password", MASTER_PASSWORD});
        if (Arrays.asList(args).contains("--name")) {
            name = args[Arrays.asList(args).indexOf("--name") + 1];
        } else {
            name = TEST_MASTER + offset;
            argsList.addAll(Arrays.asList("--name", TEST_MASTER));
        }
        String stateDir = this.masterStateDirs.resolve(name).toString();
        argsList.addAll(Arrays.asList("--state-dir", stateDir));
        argsList.addAll(Arrays.asList(args));
        return argsList;
    }

    protected MasterMain startDefaultMaster(String ... args) throws Exception {
        return this.startDefaultMaster(0, args);
    }

    protected MasterMain startDefaultMaster(int offset, String ... args) throws Exception {
        List<String> argsList = this.setupDefaultMaster(offset, args);
        if (argsList == null) {
            return null;
        }
        MasterMain master = this.startMaster(argsList.toArray(new String[argsList.size()]));
        this.waitForMasterToBeFullyUp();
        return master;
    }

    protected Map<String, MasterMain> startDefaultMasters(int numMasters, String ... args) throws Exception {
        HashMap masters = Maps.newHashMap();
        for (int i = 0; i < numMasters; ++i) {
            String name = TEST_MASTER + i;
            ArrayList argsList = Lists.newArrayList((Object[])args);
            argsList.addAll(Arrays.asList("--name", name));
            masters.put(name, this.startDefaultMaster(i, argsList.toArray(new String[argsList.size()])));
        }
        return masters;
    }

    protected void waitForMasterToBeFullyUp() throws Exception {
        log.debug("waitForMasterToBeFullyUp: beginning wait loop");
        Polling.await((long)40L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object call() {
                try {
                    HttpGet request = new HttpGet(SystemTestBase.this.masterAdminEndpoint + "/healthcheck");
                    try (CloseableHttpResponse response = SystemTestBase.this.httpClient.execute((HttpUriRequest)request);){
                        int status = response.getStatusLine().getStatusCode();
                        log.debug("waitForMasterToBeFullyUp: healthcheck endpoint returned {}", (Object)status);
                        Boolean bl = status == 200;
                        return bl;
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    protected void startDefaultMasterDontWaitForZk(CuratorClientFactory curatorClientFactory, String ... args) throws Exception {
        List<String> argsList = this.setupDefaultMaster(args);
        if (argsList == null) {
            return;
        }
        this.startMaster(curatorClientFactory, argsList.toArray(new String[argsList.size()]));
    }

    protected AgentMain startDefaultAgent(String host, String ... args) throws Exception {
        String stateDir = this.agentStateDirs.resolve(host).toString();
        ArrayList argsList = Lists.newArrayList((Object[])new String[]{"-vvvv", "--no-log-setup", "--no-http", "--name", host, "--docker=" + DOCKER_HOST.host(), "--zk", this.zk.connectString(), "--zk-session-timeout", "100", "--zk-connection-timeout", "100", "--zk-enable-acls", "--zk-acl-master-user", MASTER_USER, "--zk-acl-master-digest", MASTER_DIGEST, "--zk-acl-agent-user", AGENT_USER, "--zk-acl-agent-password", AGENT_PASSWORD, "--state-dir", stateDir, "--domain", "", "--port-range=" + this.dockerPortRange.lowerEndpoint() + ":" + this.dockerPortRange.upperEndpoint()});
        argsList.addAll(Arrays.asList(args));
        return this.startAgent(argsList.toArray(new String[argsList.size()]));
    }

    protected MasterMain startMaster(String ... args) throws Exception {
        MasterMain main = new MasterMain(args);
        main.startAsync().awaitRunning();
        this.services.add((Service)main);
        return main;
    }

    MasterMain startMaster(CuratorClientFactory curatorClientFactory, String ... args) throws Exception {
        MasterMain main = new MasterMain(curatorClientFactory, args);
        main.startAsync().awaitRunning();
        this.services.add((Service)main);
        return main;
    }

    protected AgentMain startAgent(String ... args) throws Exception {
        AgentMain main = new AgentMain(args);
        main.startAsync().awaitRunning();
        this.services.add((Service)main);
        return main;
    }

    protected void stopAgent(AgentMain main) throws Exception {
        main.stopAsync().awaitTerminated();
        this.services.remove(main);
    }

    protected JobId createJob(String name, String version, String image, List<String> command) throws Exception {
        return this.createJob(name, version, image, command, Job.EMPTY_ENV, Job.EMPTY_PORTS, Job.EMPTY_REGISTRATION);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, Date expires) throws Exception {
        return this.createJob(name, version, image, Job.EMPTY_HOSTNAME, command, Job.EMPTY_ENV, Job.EMPTY_PORTS, Job.EMPTY_REGISTRATION, Job.EMPTY_GRACE_PERIOD, Job.EMPTY_VOLUMES, expires);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, ImmutableMap<String, String> env) throws Exception {
        return this.createJob(name, version, image, command, (Map<String, String>)env, Job.EMPTY_PORTS, Job.EMPTY_REGISTRATION);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, Map<String, String> env, Map<String, PortMapping> ports) throws Exception {
        return this.createJob(name, version, image, command, env, ports, Job.EMPTY_REGISTRATION);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, Map<String, String> env, Map<String, PortMapping> ports, Map<ServiceEndpoint, ServicePorts> registration) throws Exception {
        return this.createJob(name, version, image, command, env, ports, registration, Job.EMPTY_GRACE_PERIOD, Job.EMPTY_VOLUMES);
    }

    protected JobId createJob(String name, String version, String image, List<String> command, Map<String, String> env, Map<String, PortMapping> ports, Map<ServiceEndpoint, ServicePorts> registration, Integer gracePeriod, Map<String, String> volumes) throws Exception {
        return this.createJob(name, version, image, Job.EMPTY_HOSTNAME, command, env, ports, registration, gracePeriod, volumes, Job.EMPTY_EXPIRES);
    }

    protected JobId createJob(String name, String version, String image, String hostname, List<String> command, Map<String, String> env, Map<String, PortMapping> ports, Map<ServiceEndpoint, ServicePorts> registration, Integer gracePeriod, Map<String, String> volumes, Date expires) throws Exception {
        return this.createJob(Job.newBuilder().setName(name).setVersion(version).setImage(image).setHostname(hostname).setCommand(command).setEnv(env).setPorts(ports).setRegistration(registration).setGracePeriod(gracePeriod).setVolumes(volumes).setExpires(expires).build());
    }

    protected JobId createJob(Job job) throws Exception {
        String createOutput = this.createJobRawOutput(job);
        String jobId = CharMatcher.whitespace().trimFrom((CharSequence)createOutput);
        return JobId.fromString((String)jobId);
    }

    protected String createJobRawOutput(Job job) throws Exception {
        String name = job.getId().getName();
        Preconditions.checkArgument((boolean)name.contains(this.testTag), (Object)"Job name must contain testTag to enable cleanup");
        String serializedConfig = Json.asNormalizedString((Object)job);
        File configFile = this.temporaryFolder.newFile();
        Files.write((CharSequence)serializedConfig, (File)configFile, (Charset)Charsets.UTF_8);
        ImmutableList args = ImmutableList.of((Object)"-q", (Object)"-f", (Object)configFile.getAbsolutePath());
        return this.cli("create", (List<String>)args);
    }

    protected void deployJob(JobId jobId, String host) throws Exception {
        this.deployJob(jobId, host, null);
    }

    protected void deployJob(JobId jobId, String host, String token) throws Exception {
        ArrayList deployArgs = Lists.newArrayList((Object[])new String[]{jobId.toString(), host});
        if (token != null) {
            deployArgs.addAll(ImmutableList.of((Object)"--token", (Object)token));
        }
        String deployOutput = this.cli("deploy", deployArgs);
        MatcherAssert.assertThat((Object)deployOutput, (Matcher)Matchers.containsString((String)(host + ": done")));
        String output = this.cli("status", "--host", host, "--json");
        Map statuses = (Map)Json.readUnchecked((String)output, (TypeReference)new TypeReference<Map<JobId, JobStatus>>(){});
        Assert.assertTrue((boolean)statuses.keySet().contains(jobId));
    }

    protected void undeployJob(JobId jobId, String host) throws Exception {
        String undeployOutput = this.cli("undeploy", jobId.toString(), host);
        MatcherAssert.assertThat((Object)undeployOutput, (Matcher)Matchers.containsString((String)(host + ": done")));
        String output = this.cli("status", "--host", host, "--json");
        Map statuses = (Map)Json.readUnchecked((String)output, (TypeReference)new TypeReference<Map<JobId, JobStatus>>(){});
        JobStatus status = (JobStatus)statuses.get(jobId);
        Assert.assertTrue((status == null || status.getDeployments().get(host) == null ? 1 : 0) != 0);
    }

    protected String startJob(JobId jobId, String host) throws Exception {
        return this.cli("start", jobId.toString(), host);
    }

    protected String stopJob(JobId jobId, String host) throws Exception {
        return this.cli("stop", jobId.toString(), host);
    }

    protected String deregisterHost(String host) throws Exception {
        return this.cli("deregister", host, "--yes");
    }

    protected String cli(String command, Object ... args) throws Exception {
        return this.cli(command, this.flatten(args));
    }

    protected String cli(String command, String ... args) throws Exception {
        return this.cli(command, Arrays.asList(args));
    }

    protected String cli(String command, List<String> args) throws Exception {
        List<String> commands = Arrays.asList(command, "-z", this.masterEndpoint(), "--no-log-setup");
        ArrayList allArgs = Lists.newArrayList((Iterable)Iterables.concat(commands, args));
        return this.main(allArgs).toString();
    }

    protected <T> T cliJson(Class<T> klass, String command, String ... args) throws Exception {
        return this.cliJson(klass, command, Arrays.asList(args));
    }

    protected <T> T cliJson(Class<T> klass, String command, List<String> args) throws Exception {
        ArrayList args0 = Lists.newArrayList((Object[])new String[]{"--json"});
        args0.addAll(args);
        return (T)Json.read((String)this.cli(command, args0), klass);
    }

    protected ByteArrayOutputStream main(String ... args) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        CliMain main = new CliMain(new PrintStream(out), new PrintStream(err), args);
        main.run();
        return out;
    }

    protected ByteArrayOutputStream main(Collection<String> args) throws Exception {
        return this.main(args.toArray(new String[args.size()]));
    }

    protected void awaitHostRegistered(final String name, long timeout, TimeUnit timeUnit) throws Exception {
        Polling.await((long)timeout, (TimeUnit)timeUnit, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String output = SystemTestBase.this.cli("hosts", "-q");
                return output.contains(name) ? Boolean.valueOf(true) : null;
            }
        });
    }

    protected void awaitHostRegistered(final HeliosClient client, final String host, int timeout, TimeUnit timeUnit) throws Exception {
        Polling.await((long)timeout, (TimeUnit)timeUnit, (Callable)new Callable<HostStatus>(){

            @Override
            public HostStatus call() throws Exception {
                return (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
            }
        });
    }

    protected HostStatus awaitHostStatus(final HeliosClient client, final String host, final HostStatus.Status status, int timeout, TimeUnit timeUnit) throws Exception {
        return (HostStatus)Polling.await((long)timeout, (TimeUnit)timeUnit, (Callable)new Callable<HostStatus>(){

            @Override
            public HostStatus call() throws Exception {
                HostStatus hostStatus = (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
                if (hostStatus == null) {
                    return null;
                }
                return hostStatus.getStatus() == status ? hostStatus : null;
            }
        });
    }

    protected HostStatus awaitHostStatus(final String name, final HostStatus.Status status, int timeout, TimeUnit timeUnit) throws Exception {
        return (HostStatus)Polling.await((long)timeout, (TimeUnit)timeUnit, (Callable)new Callable<HostStatus>(){

            @Override
            public HostStatus call() throws Exception {
                Map statuses;
                String output = SystemTestBase.this.cli("hosts", name, "--json");
                try {
                    statuses = (Map)Json.read((String)output, (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
                }
                catch (IOException e) {
                    return null;
                }
                HostStatus hostStatus = (HostStatus)statuses.get(name);
                if (hostStatus == null) {
                    return null;
                }
                return hostStatus.getStatus() == status ? hostStatus : null;
            }
        });
    }

    protected TaskStatus awaitJobState(final HeliosClient client, final String host, final JobId jobId, final TaskStatus.State state, int timeout, TimeUnit timeunit) throws Exception {
        return (TaskStatus)Polling.await((long)timeout, (TimeUnit)timeunit, (Callable)new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                HostStatus hostStatus = (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
                if (hostStatus == null) {
                    return null;
                }
                TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
                return taskStatus != null && taskStatus.getState() == state ? taskStatus : null;
            }
        });
    }

    protected TaskStatus awaitJobThrottle(final HeliosClient client, final String host, final JobId jobId, final ThrottleState throttled, int timeout, TimeUnit timeunit) throws Exception {
        return (TaskStatus)Polling.await((long)timeout, (TimeUnit)timeunit, (Callable)new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                HostStatus hostStatus = (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
                if (hostStatus == null) {
                    return null;
                }
                TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
                return taskStatus != null && taskStatus.getThrottled() == throttled ? taskStatus : null;
            }
        });
    }

    protected HostStatus awaitHostStatusWithLabels(HeliosClient client, String host, HostStatus.Status status, Map<String, String> labels) throws Exception {
        HostStatus hostStatus = (HostStatus)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, () -> {
            HostStatus candidate = (HostStatus)this.getOrNull(client.hostStatus(host));
            if (candidate == null || candidate.getStatus() != status || candidate.getLabels().size() != labels.size()) {
                return null;
            }
            return candidate;
        });
        MatcherAssert.assertThat((String)("host " + host + " has status=" + status + " with labels=" + hostStatus.getLabels()), (Object)hostStatus.getLabels(), (Matcher)Matchers.is(labels));
        return hostStatus;
    }

    protected HostStatus awaitHostStatusWithHostInfo(final HeliosClient client, final String host, final HostStatus.Status status, int timeout, TimeUnit timeUnit) throws Exception {
        return (HostStatus)Polling.await((long)timeout, (TimeUnit)timeUnit, (Callable)new Callable<HostStatus>(){

            @Override
            public HostStatus call() throws Exception {
                HostStatus hostStatus = (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
                if (hostStatus == null || hostStatus.getHostInfo() == null) {
                    return null;
                }
                return hostStatus.getStatus() == status ? hostStatus : null;
            }
        });
    }

    protected TaskStatus awaitTaskState(final JobId jobId, final String host, final TaskStatus.State state) throws Exception {
        return (TaskStatus)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                Map statusMap;
                String output = SystemTestBase.this.cli("status", "--json", "--job", jobId.toString());
                try {
                    statusMap = (Map)Json.read((String)output, (TypeReference)new TypeReference<Map<JobId, JobStatus>>(){});
                }
                catch (IOException e) {
                    return null;
                }
                JobStatus status = (JobStatus)statusMap.get(jobId);
                if (status == null) {
                    return null;
                }
                TaskStatus taskStatus = (TaskStatus)status.getTaskStatuses().get(host);
                if (taskStatus == null) {
                    return null;
                }
                if (taskStatus.getState() != state) {
                    return null;
                }
                return taskStatus;
            }
        });
    }

    protected void awaitTaskGone(final HeliosClient client, final String host, final JobId jobId, long timeout, TimeUnit timeunit) throws Exception {
        Polling.await((long)timeout, (TimeUnit)timeunit, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                HostStatus hostStatus = (HostStatus)SystemTestBase.this.getOrNull(client.hostStatus(host));
                TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
                Deployment deployment = (Deployment)hostStatus.getJobs().get(jobId);
                return taskStatus == null && deployment == null ? Boolean.valueOf(true) : null;
            }
        });
    }

    protected DeploymentGroupStatus awaitDeploymentGroupStatus(final HeliosClient client, final String name, final DeploymentGroupStatus.State expected) throws Exception {
        return (DeploymentGroupStatus)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<DeploymentGroupStatus>(){

            @Override
            public DeploymentGroupStatus call() throws Exception {
                DeploymentGroupStatusResponse response = (DeploymentGroupStatusResponse)SystemTestBase.this.getOrNull(client.deploymentGroupStatus(name));
                if (response != null) {
                    DeploymentGroupStatus status = response.getDeploymentGroupStatus();
                    DeploymentGroupStatus.State actual = status.getState();
                    if (actual == DeploymentGroupStatus.State.FAILED && actual != expected) {
                        throw new AssertionError((Object)("Deployment group " + name + " failed unexpectedly: " + status.getError()));
                    }
                    if (actual == expected) {
                        return status;
                    }
                }
                return null;
            }
        });
    }

    protected <T> T getOrNull(ListenableFuture<T> future) throws ExecutionException, InterruptedException {
        return (T)Futures.catching(future, Exception.class, (Function)new Function<Exception, T>(){

            public T apply(Exception ex) {
                return null;
            }
        }).get();
    }

    protected static void removeContainer(final DockerClient dockerClient, final String containerId) throws Exception {
        Polling.await((long)1L, (TimeUnit)TimeUnit.MINUTES, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                block6: {
                    try {
                        dockerClient.killContainer(containerId);
                    }
                    catch (DockerRequestException e) {
                        if (e.getResponseBody().contains("is not running")) break block6;
                        throw e;
                    }
                }
                try {
                    dockerClient.removeContainer(containerId);
                    return true;
                }
                catch (ContainerNotFoundException e) {
                    return true;
                }
                catch (DockerException e) {
                    if (e instanceof DockerRequestException && ((DockerRequestException)((Object)e)).getResponseBody().contains("Driver btrfs failed to remove root filesystem")) {
                        return true;
                    }
                    return null;
                }
            }
        });
    }

    protected List<Container> listContainers(DockerClient dockerClient, String needle) throws DockerException, InterruptedException {
        List containers = dockerClient.listContainers(new DockerClient.ListContainersParam[0]);
        ArrayList matches = Lists.newArrayList();
        block0: for (Container container : containers) {
            if (container.names() == null) continue;
            for (String name : container.names()) {
                if (!name.contains(needle)) continue;
                matches.add(container);
                continue block0;
            }
        }
        return matches;
    }

    protected List<String> flatten(Object ... values) {
        List<Object> valuesList = Arrays.asList(values);
        return this.flatten(valuesList);
    }

    protected List<String> flatten(Iterable<?> values) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object value : values) {
            if (value instanceof Iterable) {
                list.addAll(this.flatten((Iterable)value));
                continue;
            }
            if (value.getClass() == String[].class) {
                list.addAll(Arrays.asList((String[])value));
                continue;
            }
            if (value instanceof String) {
                list.add((String)value);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return list;
    }

    protected void assertJobsEqual(Map<JobId, Job> expected, Map<JobId, Job> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (Map.Entry<JobId, Job> entry : actual.entrySet()) {
            this.assertJobEquals(expected.get(entry.getKey()), entry.getValue());
        }
    }

    protected void assertJobEquals(Job expected, Job actual) {
        Job.Builder expectedBuilder = expected.toBuilder();
        Job.Builder actualBuilder = actual.toBuilder();
        HashMap metadata = Maps.newHashMap((Map)actual.getMetadata());
        for (Map.Entry entry : JobCreateCommand.DEFAULT_METADATA_ENVVARS.entrySet()) {
            String envVar = (String)entry.getKey();
            String metadataKey = (String)entry.getValue();
            String envValue = System.getenv(envVar);
            if (envValue == null || !actual.getMetadata().containsKey(metadataKey) || !((String)actual.getMetadata().get(metadataKey)).equals(envValue)) continue;
            metadata.remove(metadataKey);
        }
        actualBuilder.setMetadata((Map)metadata);
        actualBuilder.setCreated(null);
        expectedBuilder.setHash(actualBuilder.build().getId().getHash());
        Assert.assertEquals((Object)expectedBuilder.build(), (Object)actualBuilder.build());
    }

    protected static String randomHexString() {
        return Integer.toHexString(ThreadLocalRandom.current().nextInt());
    }

    protected void resetAgentStateDir() throws IOException {
        this.agentStateDirs = this.temporaryFolder.newFolder(UUID.randomUUID().toString()).toPath();
    }

    protected static boolean isCircleCi() {
        String env = System.getenv("CIRCLECI");
        return env != null && "true".equalsIgnoreCase(env);
    }
}

