/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.Sets;
import com.spotify.helios.Polling;
import com.spotify.helios.servicescommon.ZooKeeperAclProviders;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLProvider;
import org.junit.Assert;
import org.junit.Test;

public class ZooKeeperAclTest
extends SystemTestBase {
    private final ACLProvider aclProvider = ZooKeeperAclProviders.heliosAclProvider((String)"helios-master", (String)MASTER_DIGEST, (String)"helios-agent", (String)AGENT_DIGEST);

    @Test
    public void testMasterSetsRootNodeAcls() throws Exception {
        this.startDefaultMaster(new String[0]);
        CuratorFramework curator = this.zk().curatorWithSuperAuth();
        List acls = (List)curator.getACL().forPath("/");
        Assert.assertEquals((Object)Sets.newHashSet((Iterable)this.aclProvider.getAclForPath("/")), (Object)Sets.newHashSet((Iterable)acls));
    }

    @Test
    public void testAgentCreatedNodesHaveAcls() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent("test-host", new String[0]);
        this.awaitHostRegistered("test-host", 40L, TimeUnit.SECONDS);
        CuratorFramework curator = this.zk().curatorWithSuperAuth();
        String path = Paths.configHost((String)"test-host");
        List acls = (List)curator.getACL().forPath(path);
        Assert.assertEquals((Object)Sets.newHashSet((Iterable)this.aclProvider.getAclForPath(path)), (Object)Sets.newHashSet((Iterable)acls));
    }

    @Test
    public void testMasterCreatedNodesHaveAcls() throws Exception {
        this.startDefaultMaster(new String[0]);
        Polling.await((long)40L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((List)ZooKeeperAclTest.this.defaultClient().listMasters().get()).isEmpty() ? null : Boolean.valueOf(true);
            }
        });
        CuratorFramework curator = this.zk().curatorWithSuperAuth();
        String path = Paths.statusMasterUp((String)"test-master");
        List acls = (List)curator.getACL().forPath(path);
        Assert.assertEquals((Object)Sets.newHashSet((Iterable)this.aclProvider.getAclForPath(path)), (Object)Sets.newHashSet((Iterable)acls));
    }
}

