/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TerminationTest
extends SystemTestBase {
    @Before
    public void setup() throws Exception {
        DockerClient dockerClient = this.getNewDockerClient();
        Assume.assumeThat((Object)dockerClient.info().executionDriver(), (Matcher)Matchers.startsWith((String)"native"));
    }

    @Test
    public void testNoIntOnExit() throws Exception {
        String log;
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        this.startDefaultAgent(host, new String[0]);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, host, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Job jobToInterrupt = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(Arrays.asList("/bin/sh", "-c", "trap handle 2; handle() { echo int; exit 0; }; while true; do sleep 1; done")).build();
        JobId jobId = this.createJob(jobToInterrupt);
        this.deployJob(jobId, host);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        client.setGoal(new Deployment(jobId, Goal.STOP, Deployment.EMTPY_DEPLOYER_USER, Deployment.EMPTY_DEPLOYER_MASTER, Deployment.EMPTY_DEPLOYMENT_GROUP_NAME), host);
        TaskStatus taskStatus = this.awaitTaskState(jobId, host, TaskStatus.State.STOPPED);
        try (DockerClient dockerClient = this.getNewDockerClient();
             LogStream logs = dockerClient.logs(taskStatus.getContainerId(), new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout()});){
            log = logs.readFully();
        }
        Assert.assertEquals((Object)"", (Object)log);
    }

    @Test
    public void testTermOnExit() throws Exception {
        String log;
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        this.startDefaultAgent(host, new String[0]);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, host, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Job jobToInterrupt = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(Arrays.asList("/bin/sh", "-c", "trap handle 15; handle() { echo term; exit 0; }; while true; do sleep 1; done")).build();
        JobId jobId = this.createJob(jobToInterrupt);
        this.deployJob(jobId, host);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        client.setGoal(new Deployment(jobId, Goal.STOP, Deployment.EMTPY_DEPLOYER_USER, Deployment.EMPTY_DEPLOYER_MASTER, Deployment.EMPTY_DEPLOYMENT_GROUP_NAME), host);
        TaskStatus taskStatus = this.awaitTaskState(jobId, host, TaskStatus.State.STOPPED);
        try (DockerClient dockerClient = this.getNewDockerClient();
             LogStream logs = dockerClient.logs(taskStatus.getContainerId(), new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout()});){
            log = logs.readFully();
        }
        Assert.assertEquals((Object)"term\n", (Object)log);
    }
}

