/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.spotify.helios.Polling;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.DeploymentGroupStatus;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.RolloutOptions;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.DeploymentGroupStatusResponse;
import com.spotify.helios.common.protocol.HostDeregisterResponse;
import com.spotify.helios.common.protocol.RemoveDeploymentGroupResponse;
import com.spotify.helios.common.protocol.RollingUpdateResponse;
import com.spotify.helios.master.MasterMain;
import com.spotify.helios.system.SystemTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class DeploymentGroupTest
extends SystemTestBase {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String TEST_GROUP = "my_group";
    private static final String TEST_LABEL = "foo=bar";
    private static final String TOKEN = "foo-token";
    private MasterMain master;
    @Rule
    public final TestName testName = new TestName();

    @Before
    public void initialize() throws Exception {
        System.out.printf("- %s\n", this.testName.getMethodName());
        this.master = this.startDefaultMaster(new String[0]);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String output = DeploymentGroupTest.this.cli("masters", new String[0]);
                return output.contains(DeploymentGroupTest.this.masterName()) ? output : null;
            }
        });
    }

    @Test
    public void testListDeploymentGroups() throws Exception {
        this.cli("create-deployment-group", "group2", TEST_LABEL);
        this.cli("create-deployment-group", "group1", TEST_LABEL);
        String output = this.cli("list-deployment-groups", "--json");
        List deploymentGroups = (List)OBJECT_MAPPER.readValue(output, (TypeReference)new TypeReference<List<String>>(){});
        Assert.assertEquals(Arrays.asList("group1", "group2"), (Object)deploymentGroups);
    }

    @Test
    public void testRollingUpdate() throws Exception {
        ImmutableList hosts = ImmutableList.of((Object)("dc1-" + this.testHost() + "-a1.dc1.example.com"), (Object)("dc1-" + this.testHost() + "-a2.dc1.example.com"), (Object)("dc2-" + this.testHost() + "-a1.dc2.example.com"), (Object)("dc2-" + this.testHost() + "-a3.dc2.example.com"), (Object)("dc3-" + this.testHost() + "-a4.dc3.example.com"));
        for (Object host : hosts) {
            this.startDefaultAgent((String)host, "--labels", TEST_LABEL);
        }
        HeliosClient client = this.defaultClient();
        for (String host : hosts) {
            this.awaitHostStatus(client, host, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        }
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        Job job1 = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setHostname(null).setCommand(IDLE_COMMAND).setEnv(Collections.emptyMap()).setPorts(Collections.emptyMap()).setRegistration(Collections.emptyMap()).setGracePeriod(null).setVolumes(Collections.emptyMap()).setExpires(null).setRolloutOptions(RolloutOptions.newBuilder().build()).build();
        JobId jobId = this.createJob(job1);
        Thread.sleep(1000L);
        this.cli("rolling-update", "--async", this.testJobNameAndVersion, TEST_GROUP);
        for (String host : hosts) {
            this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        }
        Deployment deployment = (Deployment)((HostStatus)this.defaultClient().hostStatus((String)hosts.get(0)).get()).getJobs().get(jobId);
        Assert.assertEquals((Object)TEST_GROUP, (Object)deployment.getDeploymentGroupName());
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        String secondJobVersion = this.testJobVersion + "2";
        String secondJobNameAndVersion = this.testJobNameAndVersion + "2";
        Job job2 = Job.newBuilder().setName(this.testJobName).setVersion(secondJobVersion).setImage("spotify/busybox:latest").setHostname(null).setCommand(IDLE_COMMAND).setEnv(Collections.emptyMap()).setPorts(Collections.emptyMap()).setRegistration(Collections.emptyMap()).setGracePeriod(null).setVolumes(Collections.emptyMap()).setExpires(null).setRolloutOptions(RolloutOptions.newBuilder().build()).build();
        JobId secondJobId = this.createJob(job2);
        String output = this.cli("rolling-update", secondJobNameAndVersion, TEST_GROUP);
        ArrayList lines = Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)output));
        for (int i = 0; i < hosts.size(); ++i) {
            Assert.assertThat((Object)((String)lines.get(i + 2)), (Matcher)Matchers.containsString((String)((String)hosts.get(i))));
        }
        for (String host : hosts) {
            this.awaitTaskState(secondJobId, host, TaskStatus.State.RUNNING);
        }
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
    }

    @Test
    public void testAgentAddedAfterRollingUpdateIsDeployed() throws Exception {
        this.startDefaultAgent(this.testHost(), "--labels", TEST_LABEL);
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("rolling-update", "--async", this.testJobNameAndVersion, TEST_GROUP);
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.RUNNING);
        this.startDefaultAgent(this.testHost() + "2", "--labels", TEST_LABEL);
        this.awaitTaskState(jobId, this.testHost() + "2", TaskStatus.State.RUNNING);
    }

    private void awaitUpWithLabels(String host, String ... labelPairs) throws Exception {
        Preconditions.checkArgument((labelPairs.length % 2 == 0 ? 1 : 0) != 0, (Object)"Must pass even number of pairs for labels");
        HashMap<String, String> labels = new HashMap<String, String>();
        for (int i = 0; i < labelPairs.length - 1; i += 2) {
            labels.put(labelPairs[i], labelPairs[i + 1]);
        }
        this.awaitHostStatusWithLabels(this.defaultClient(), host, HostStatus.Status.UP, labels);
    }

    private void awaitUndeployed(String host, JobId jobId) throws Exception {
        Deployment oldDeployment = (Deployment)this.defaultClient().deployment(host, jobId).get();
        Assert.assertThat((Object)oldDeployment, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.awaitTaskGone(this.defaultClient(), host, jobId, 400L, TimeUnit.SECONDS);
    }

    @Test
    public void testRemovingAgentTagUndeploysJob() throws Exception {
        HeliosClient client = this.defaultClient();
        String oldHost = this.testHost();
        String deregisterHost = this.testHost() + "2";
        String unchangedHost = this.testHost() + "3";
        String newHost = this.testHost() + "4";
        String anotherNewHost = this.testHost() + "5";
        AgentMain oldAgent = this.startDefaultAgent(oldHost, "--labels", TEST_LABEL);
        this.awaitUpWithLabels(oldHost, "foo", "bar");
        AgentMain deregisterAgent = this.startDefaultAgent(deregisterHost, "--labels", TEST_LABEL);
        this.awaitUpWithLabels(deregisterHost, "foo", "bar");
        this.startDefaultAgent(unchangedHost, "--labels", TEST_LABEL);
        this.awaitUpWithLabels(unchangedHost, "foo", "bar");
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("rolling-update", "--async", this.testJobNameAndVersion, TEST_GROUP);
        this.awaitTaskState(jobId, oldHost, TaskStatus.State.RUNNING);
        this.awaitTaskState(jobId, deregisterHost, TaskStatus.State.RUNNING);
        this.awaitTaskState(jobId, unchangedHost, TaskStatus.State.RUNNING);
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.startDefaultAgent(newHost, "--labels", TEST_LABEL);
        this.awaitUpWithLabels(newHost, "foo", "bar");
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.ROLLING_OUT);
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.awaitTaskState(jobId, newHost, TaskStatus.State.RUNNING);
        this.stopAgent(oldAgent);
        oldAgent = this.startDefaultAgent(oldHost, "--labels", TEST_LABEL, "another=label");
        this.awaitUpWithLabels(oldHost, "foo", "bar", "another", "label");
        this.awaitTaskState(jobId, oldHost, TaskStatus.State.RUNNING);
        this.stopAgent(oldAgent);
        oldAgent = this.startDefaultAgent(oldHost, "--labels", "foo=notbar");
        this.awaitUpWithLabels(oldHost, "foo", "notbar");
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.ROLLING_OUT);
        this.startDefaultAgent(anotherNewHost, "--labels", TEST_LABEL);
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.ROLLING_OUT);
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.awaitUndeployed(oldHost, jobId);
        this.stopAgent(oldAgent);
        this.startDefaultAgent(oldHost, "--labels", TEST_LABEL);
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.ROLLING_OUT);
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.awaitTaskState(jobId, oldHost, TaskStatus.State.RUNNING);
        this.stopAgent(deregisterAgent);
        HostDeregisterResponse deregisterResponse = (HostDeregisterResponse)client.deregisterHost(deregisterHost).get();
        Assert.assertEquals((Object)HostDeregisterResponse.Status.OK, (Object)deregisterResponse.getStatus());
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.ROLLING_OUT);
        this.awaitDeploymentGroupStatus(client, TEST_GROUP, DeploymentGroupStatus.State.DONE);
    }

    @Test
    public void testRollingUpdateGroupNotFound() throws Exception {
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL, "baz=qux");
        this.cli("create", "my_job:2", "my_image");
        Assert.assertEquals((Object)RollingUpdateResponse.Status.DEPLOYMENT_GROUP_NOT_FOUND, (Object)((RollingUpdateResponse)OBJECT_MAPPER.readValue(this.cli("rolling-update", "--json", "--async", "my_job:2", "oops"), RollingUpdateResponse.class)).getStatus());
    }

    @Test
    public void testStatusNoRollingUpdate() throws Exception {
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL, "baz=qux");
        Assert.assertEquals((Object)DeploymentGroupStatusResponse.Status.IDLE, (Object)((DeploymentGroupStatusResponse)OBJECT_MAPPER.readValue(this.cli("deployment-group-status", "--json", TEST_GROUP), DeploymentGroupStatusResponse.class)).getStatus());
    }

    @Test
    public void testRollingUpdateMigrate() throws Exception {
        final String host = this.testHost();
        this.startDefaultAgent(host, "--labels", TEST_LABEL);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        final JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.deployJob(jobId, host);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        this.cli("rolling-update", "--async", "--migrate", this.testJobNameAndVersion, TEST_GROUP);
        String jobDeploymentGroup = (String)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                Deployment deployment = (Deployment)((HostStatus)DeploymentGroupTest.this.defaultClient().hostStatus(host).get()).getJobs().get(jobId);
                if (deployment != null && !Strings.isNullOrEmpty((String)deployment.getDeploymentGroupName())) {
                    return deployment.getDeploymentGroupName();
                }
                return null;
            }
        });
        Assert.assertEquals((Object)TEST_GROUP, (Object)jobDeploymentGroup);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
    }

    @Test
    public void testRollingUpdateMigrateWithToken() throws Exception {
        final String host = this.testHost();
        this.startDefaultAgent(host, "--labels", TEST_LABEL);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setToken(TOKEN).build();
        final JobId jobId = this.createJob(job);
        this.deployJob(jobId, host, TOKEN);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        this.cli("rolling-update", "--async", "--migrate", "--token", TOKEN, this.testJobNameAndVersion, TEST_GROUP);
        String jobDeploymentGroup = (String)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                Deployment deployment = (Deployment)((HostStatus)DeploymentGroupTest.this.defaultClient().hostStatus(host).get()).getJobs().get(jobId);
                if (deployment != null && !Strings.isNullOrEmpty((String)deployment.getDeploymentGroupName())) {
                    return deployment.getDeploymentGroupName();
                }
                return null;
            }
        });
        Assert.assertEquals((Object)TEST_GROUP, (Object)jobDeploymentGroup);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
    }

    @Test
    public void testRollingUpdateMigrateNothingToUndeploy() throws Exception {
        final String host = this.testHost();
        this.startDefaultAgent(host, "--labels", TEST_LABEL);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        String manualJobVersion = "foo-" + this.testJobVersion;
        JobId manualJobId = this.createJob(this.testJobName, manualJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.deployJob(manualJobId, host);
        this.awaitTaskState(manualJobId, host, TaskStatus.State.RUNNING);
        final JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        this.cli("rolling-update", "--async", "--migrate", this.testJobNameAndVersion, TEST_GROUP);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        String jobDeploymentGroup = (String)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                Deployment deployment = (Deployment)((HostStatus)DeploymentGroupTest.this.defaultClient().hostStatus(host).get()).getJobs().get(jobId);
                if (deployment != null && !Strings.isNullOrEmpty((String)deployment.getDeploymentGroupName())) {
                    return deployment.getDeploymentGroupName();
                }
                return null;
            }
        });
        Assert.assertEquals((Object)TEST_GROUP, (Object)jobDeploymentGroup);
        Deployment manualDeployment = (Deployment)((HostStatus)this.defaultClient().hostStatus(host).get()).getJobs().get(manualJobId);
        Assert.assertNotNull((Object)manualDeployment);
        Assert.assertEquals((Object)Goal.START, (Object)manualDeployment.getGoal());
    }

    @Test
    public void testStopDeploymentGroup() throws Exception {
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL, "baz=qux");
        this.cli("create", "my_job:2", "my_image");
        Assert.assertThat((Object)this.cli("stop-deployment-group", TEST_GROUP), (Matcher)Matchers.containsString((String)"Deployment-group my_group stopped"));
        DeploymentGroupStatusResponse status = (DeploymentGroupStatusResponse)Json.read((String)this.cli("deployment-group-status", "--json", TEST_GROUP), DeploymentGroupStatusResponse.class);
        Assert.assertEquals((Object)DeploymentGroupStatusResponse.Status.FAILED, (Object)status.getStatus());
        Assert.assertEquals((Object)"Stopped by user", (Object)status.getError());
    }

    @Test
    public void testStopDeploymentGroupGroupNotFound() throws Exception {
        Assert.assertThat((Object)this.cli("stop-deployment-group", TEST_GROUP), (Matcher)Matchers.containsString((String)"Deployment-group my_group not found"));
    }

    @Test
    public void testRollingUpdateCoordination() throws Exception {
        this.master.stopAsync().awaitTerminated();
        Map<String, MasterMain> masters = this.startDefaultMasters(3, new String[0]);
        LinkedHashMap agents = Maps.newLinkedHashMap();
        for (int i = 0; i < 20; ++i) {
            String name = "test-host" + i;
            agents.put(name, this.startDefaultAgent(name, "--labels", TEST_LABEL));
        }
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("rolling-update", "--async", "--par", String.valueOf(agents.size()), this.testJobNameAndVersion, TEST_GROUP);
        this.awaitTaskState(jobId, (String)Iterables.getLast(agents.keySet()), TaskStatus.State.RUNNING);
        HashSet deployingMasters = Sets.newHashSet();
        Map hostStatuses = (Map)this.defaultClient().hostStatuses((List)Lists.newArrayList(agents.keySet())).get();
        for (HostStatus status : hostStatuses.values()) {
            for (Deployment deployment : status.getJobs().values()) {
                deployingMasters.add(deployment.getDeployerMaster());
            }
        }
        Assert.assertEquals((long)masters.size(), (long)deployingMasters.size());
    }

    @Test
    public void testIdenticalRollouts() throws Exception {
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("rolling-update", "--async", this.testJobNameAndVersion, TEST_GROUP);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.cli("stop-deployment-group", TEST_GROUP);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.FAILED);
        this.cli("rolling-update", "--async", this.testJobNameAndVersion, TEST_GROUP);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
    }

    @Test
    public void testStoppedJob() throws Exception {
        String host = this.testHost();
        this.startDefaultAgent(host, "--labels", TEST_LABEL);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        JobId firstJobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        String secondJobVersion = DeploymentGroupTest.randomHexString();
        String secondJobNameAndVersion = this.testJobName + ":" + secondJobVersion;
        JobId secondJobId = this.createJob(this.testJobName, secondJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("rolling-update", "--async", this.testJobNameAndVersion, TEST_GROUP);
        this.awaitTaskState(firstJobId, host, TaskStatus.State.RUNNING);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.cli("stop", this.testJobNameAndVersion, host);
        this.awaitTaskState(firstJobId, host, TaskStatus.State.STOPPED);
        this.cli("rolling-update", "--async", secondJobNameAndVersion, TEST_GROUP);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.awaitTaskState(secondJobId, host, TaskStatus.State.RUNNING);
        JobStatus status = (JobStatus)client.jobStatus(firstJobId).get();
        Assert.assertThat((Object)status.getDeployments().isEmpty(), (Matcher)Matchers.is((Object)true));
        this.cli("stop", secondJobNameAndVersion, host);
        this.awaitTaskState(secondJobId, host, TaskStatus.State.STOPPED);
        this.cli("rolling-update", "--async", secondJobNameAndVersion, TEST_GROUP);
        this.awaitTaskState(secondJobId, host, TaskStatus.State.RUNNING);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
    }

    @Test
    public void testRollingUpdateWithOverlap() throws Exception {
        ImmutableList hosts = ImmutableList.of((Object)("dc1-" + this.testHost() + "-a1.dc1.example.com"), (Object)("dc1-" + this.testHost() + "-a2.dc1.example.com"), (Object)("dc2-" + this.testHost() + "-a1.dc2.example.com"), (Object)("dc2-" + this.testHost() + "-a3.dc2.example.com"), (Object)("dc3-" + this.testHost() + "-a4.dc3.example.com"));
        for (Object host : hosts) {
            this.startDefaultAgent((String)host, "--labels", TEST_LABEL);
        }
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("rolling-update", "--async", "--overlap", this.testJobNameAndVersion, TEST_GROUP);
        for (String host : hosts) {
            this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        }
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        String secondJobVersion = this.testJobVersion + "2";
        String secondJobNameAndVersion = this.testJobNameAndVersion + "2";
        JobId secondJobId = this.createJob(this.testJobName, secondJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("rolling-update", "--async", "--overlap", secondJobNameAndVersion, TEST_GROUP);
        for (String host : hosts) {
            this.awaitTaskState(secondJobId, host, TaskStatus.State.RUNNING);
        }
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
    }

    @Ignore
    @Test
    public void testRollingUpdatePerformance() throws Exception {
        ImmutableList hosts = ImmutableList.of((Object)("dc1-" + this.testHost() + "-a1.dc1.example.com"), (Object)("dc1-" + this.testHost() + "-a2.dc1.example.com"), (Object)("dc2-" + this.testHost() + "-a1.dc2.example.com"), (Object)("dc2-" + this.testHost() + "-a3.dc2.example.com"), (Object)("dc3-" + this.testHost() + "-a4.dc3.example.com"));
        for (Object host : hosts) {
            this.startDefaultAgent((String)host, "--labels", TEST_LABEL);
        }
        HeliosClient client = this.defaultClient();
        for (String host : hosts) {
            this.awaitHostStatus(client, host, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        }
        for (int i = 0; i < 50; ++i) {
            this.cli("create-deployment-group", "--json", "my_group-" + i, "tol=ahdsksajd");
            this.cli("rolling-update", "--async", this.testJobNameAndVersion, "my_group-" + i);
        }
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        Thread.sleep(2000L);
        this.cli("rolling-update", "--async", this.testJobNameAndVersion, TEST_GROUP);
        long t0 = System.currentTimeMillis();
        for (String host : hosts) {
            this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        }
        Deployment deployment = (Deployment)((HostStatus)this.defaultClient().hostStatus((String)hosts.get(0)).get()).getJobs().get(jobId);
        Assert.assertEquals((Object)TEST_GROUP, (Object)deployment.getDeploymentGroupName());
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        System.out.printf("1 active / 0 inactive: Time to roll out: %.2f s\n", (double)(System.currentTimeMillis() - t0) / 1000.0);
    }

    @Test
    public void testRollingUpdateWithOverlapAndParallelism() throws Exception {
        ImmutableList hosts = ImmutableList.of((Object)("dc1-" + this.testHost() + "-a1.dc1.example.com"), (Object)("dc1-" + this.testHost() + "-a2.dc1.example.com"), (Object)("dc2-" + this.testHost() + "-a1.dc2.example.com"), (Object)("dc2-" + this.testHost() + "-a3.dc2.example.com"), (Object)("dc3-" + this.testHost() + "-a4.dc3.example.com"));
        for (Object host : hosts) {
            this.startDefaultAgent((String)host, "--labels", TEST_LABEL);
        }
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("rolling-update", "--async", "-p", "2", "--overlap", this.testJobNameAndVersion, TEST_GROUP);
        for (String host : hosts) {
            this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        }
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        String secondJobVersion = this.testJobVersion + "2";
        String secondJobNameAndVersion = this.testJobNameAndVersion + "2";
        JobId secondJobId = this.createJob(this.testJobName, secondJobVersion, "spotify/busybox:latest", IDLE_COMMAND);
        this.cli("rolling-update", "--async", "-p", "2", "--overlap", secondJobNameAndVersion, TEST_GROUP);
        for (String host : hosts) {
            this.awaitTaskState(secondJobId, host, TaskStatus.State.RUNNING);
        }
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
    }

    @Test
    public void testRollingUpdateWithToken() throws Exception {
        String host = this.testHost();
        this.startDefaultAgent(host, "--labels", TEST_LABEL);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setToken(TOKEN).build();
        JobId jobId = this.createJob(job);
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        this.cli("rolling-update", "--async", "--token", TOKEN, this.testJobNameAndVersion, TEST_GROUP);
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        String output = this.cli("undeploy", jobId.toString(), host);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"FORBIDDEN"));
        this.awaitDeploymentGroupStatus(this.defaultClient(), TEST_GROUP, DeploymentGroupStatus.State.DONE);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
    }

    @Test
    public void testRemoveDeploymentGroupInactive() throws Exception {
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        this.cli("rolling-update", "--async", "--migrate", this.testJobNameAndVersion, TEST_GROUP);
        RemoveDeploymentGroupResponse response = (RemoveDeploymentGroupResponse)this.defaultClient().removeDeploymentGroup(TEST_GROUP).get();
        Assert.assertEquals((Object)RemoveDeploymentGroupResponse.Status.REMOVED, (Object)response.getStatus());
    }

    @Test
    public void testRemoveDeploymentGroupActive() throws Exception {
        String host = this.testHost();
        this.startDefaultAgent(host, "--labels", TEST_LABEL);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "invalid_image", IDLE_COMMAND);
        this.cli("create-deployment-group", "--json", TEST_GROUP, TEST_LABEL);
        this.cli("rolling-update", "--async", "--migrate", this.testJobNameAndVersion, TEST_GROUP);
        RemoveDeploymentGroupResponse response = (RemoveDeploymentGroupResponse)this.defaultClient().removeDeploymentGroup(TEST_GROUP).get();
        Assert.assertEquals((Object)RemoveDeploymentGroupResponse.Status.REMOVED, (Object)response.getStatus());
    }
}

