/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.spotify.helios.Polling;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LabelTest
extends SystemTestBase {
    private Callable<Map<String, Map<String, String>>> hostLabels(Set<String> hosts) {
        return () -> {
            ImmutableMap.Builder hostLabels = ImmutableMap.builder();
            for (String host : hosts) {
                Map status = (Map)Json.read((String)this.cli("hosts", host, "--json"), (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
                HostStatus hostStatus = (HostStatus)status.get(host);
                if (hostStatus == null) {
                    return null;
                }
                Map labels = hostStatus.getLabels();
                if (labels != null && !labels.isEmpty()) {
                    hostLabels.put((Object)host, (Object)labels);
                    continue;
                }
                return null;
            }
            return hostLabels.build();
        };
    }

    @Test
    public void testHostLabels() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), "--labels", "role=foo", "xyz=123");
        Map labels = (Map)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, this.hostLabels((Set<String>)ImmutableSet.of((Object)this.testHost())));
        ImmutableMap expectedLabels = ImmutableMap.of((Object)this.testHost(), (Object)ImmutableMap.of((Object)"role", (Object)"foo", (Object)"xyz", (Object)"123"));
        Assert.assertThat((Object)labels, (Matcher)CoreMatchers.equalTo((Object)expectedLabels));
    }

    @Test
    public void testCliHosts() throws Exception {
        String testHost1 = this.testHost() + "1";
        String testHost2 = this.testHost() + "2";
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(testHost1, "--labels", "role=foo", "xyz=123");
        this.startDefaultAgent(testHost2, "--labels", "role=bar", "xyz=123");
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, this.hostLabels((Set<String>)ImmutableSet.of((Object)testHost1, (Object)testHost2)));
        String fooHosts = this.cli("hosts", "-s", "role=foo");
        Assert.assertThat((Object)fooHosts, (Matcher)CoreMatchers.containsString((String)testHost1));
        Assert.assertThat((Object)fooHosts, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)testHost2)));
        String xyzHosts = this.cli("hosts", "-s", "xyz=123");
        Assert.assertThat((Object)xyzHosts, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)testHost1), (Matcher)CoreMatchers.containsString((String)testHost2)));
        String fooAndXyzHosts = this.cli("hosts", "-s", "role=foo", "-s", "xyz=123");
        Assert.assertThat((Object)fooAndXyzHosts, (Matcher)CoreMatchers.containsString((String)testHost1));
        Assert.assertThat((Object)fooAndXyzHosts, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)testHost2)));
        String notFooHosts = this.cli("hosts", "-s", "role!=foo");
        Assert.assertThat((Object)notFooHosts, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)testHost1)));
        Assert.assertThat((Object)notFooHosts, (Matcher)CoreMatchers.containsString((String)testHost2));
        String inFooBarHosts = this.cli("hosts", "-s", "role in (foo, bar)");
        Assert.assertThat((Object)inFooBarHosts, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)testHost1), (Matcher)CoreMatchers.containsString((String)testHost2)));
        String notInFooBarHosts = this.cli("hosts", "-s", "role notin (foo, bar)");
        Assert.assertThat((Object)notInFooBarHosts, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)testHost1), (Matcher)CoreMatchers.containsString((String)testHost2))));
        String nonHosts = this.cli("hosts", "-s", "role=doesnt_exist");
        Assert.assertThat((Object)nonHosts, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)testHost1), (Matcher)CoreMatchers.containsString((String)testHost2))));
        String nonHosts2 = this.cli("hosts", "-s", "role=doesnt_exist", "-s", "xyz=123");
        Assert.assertThat((Object)nonHosts2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)testHost1), (Matcher)CoreMatchers.containsString((String)testHost2))));
    }
}

