/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Info;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.Resources;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ResourcesTest
extends SystemTestBase {
    private HeliosClient client;
    private Job job;
    private static final Long MEMORY = 0xA00000L;
    private static final Long MEMORY_SWAP = 0xA00003L;
    private static final Long CPU_SHARES = 512L;
    private static final String CPUSET_CPUS = "0-1";

    @Before
    public void setup() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setResources(new Resources(MEMORY, MEMORY_SWAP, CPU_SHARES, CPUSET_CPUS)).setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
    }

    @Test
    public void testClient() throws Exception {
        Assume.assumeFalse((boolean)ResourcesTest.isCircleCi());
        CreateJobResponse created = (CreateJobResponse)this.client.createJob(this.job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        JobId jobId = this.job.getId();
        this.awaitHostRegistered(this.client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(this.client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)this.client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        TaskStatus taskStatus = this.awaitJobState(this.client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.assertJobEquals(this.job, taskStatus.getJob());
        try (DockerClient docker = this.getNewDockerClient();){
            HostConfig hostConfig = docker.inspectContainer(taskStatus.getContainerId()).hostConfig();
            Assert.assertEquals((Object)CPU_SHARES, (Object)hostConfig.cpuShares());
            Assert.assertEquals((Object)CPUSET_CPUS, (Object)hostConfig.cpusetCpus());
            Info info = docker.info();
            Iterable split = Splitter.on((String)".").split((CharSequence)docker.version().apiVersion());
            int major = Integer.parseInt((String)Iterables.get((Iterable)split, (int)0, (Object)"0"));
            int minor = Integer.parseInt((String)Iterables.get((Iterable)split, (int)1, (Object)"0"));
            if (major >= 1 && minor >= 19) {
                if (info.memoryLimit().booleanValue()) {
                    Assert.assertEquals((Object)MEMORY, (Object)hostConfig.memory());
                }
                if (info.swapLimit().booleanValue()) {
                    Assert.assertEquals((Object)MEMORY_SWAP, (Object)hostConfig.memorySwap());
                }
            }
        }
    }
}

