/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AddExtraHostTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        try (DockerClient docker = this.getNewDockerClient();){
            this.startDefaultMaster(new String[0]);
            this.startDefaultAgent(this.testHost(), "--add-host", "secrethost:169.254.169.254");
            this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
            ImmutableList command = ImmutableList.of((Object)"cat", (Object)"/etc/hosts");
            JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "spotify/busybox:latest", (List<String>)command);
            this.deployJob(jobId, this.testHost());
            TaskStatus taskStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.EXITED);
            try (LogStream logs = docker.logs(taskStatus.getContainerId(), new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});){
                String log = logs.readFully();
                Assert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"169.254.169.254\tsecrethost"));
            }
        }
    }
}

