/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.io.ByteStreams;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.system.SystemTestBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class ApiTest
extends SystemTestBase {
    @Test
    public void testHashLessJobCreation() throws Exception {
        this.startDefaultMaster(new String[0]);
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        ObjectNode json = (ObjectNode)Json.reader().readTree(Json.asString((Object)job));
        json.set("id", (JsonNode)TextNode.valueOf((String)(this.testJobName + ":" + this.testJobVersion)));
        HttpURLConnection req = this.post("/jobs?user=test-user", Json.asBytes((Object)json));
        Assert.assertEquals((long)req.getResponseCode(), (long)200L);
        CreateJobResponse res = (CreateJobResponse)Json.read((byte[])ByteStreams.toByteArray((InputStream)req.getInputStream()), CreateJobResponse.class);
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)res.getStatus());
        Assert.assertTrue((boolean)res.getErrors().isEmpty());
        Assert.assertEquals((Object)job.getId().toString(), (Object)res.getId());
    }

    private HttpURLConnection post(String path, byte[] body) throws IOException {
        URL url = new URL(this.masterEndpoint() + path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.getOutputStream().write(body);
        return connection;
    }
}

