/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.system.SystemTestBase;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ConfigFileJobCreationTest
extends SystemTestBase {
    private final int externalPort;

    public ConfigFileJobCreationTest() {
        this.externalPort = this.temporaryPorts.localPort("external");
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        String name = this.testJobName;
        String version = "17";
        String image = "spotify/busybox:latest";
        ImmutableMap ports = ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711), (Object)"bar", (Object)PortMapping.of((int)5000, (Integer)this.externalPort), (Object)"p-tcp", (Object)PortMapping.of((int)1900, (Integer)2900, (String)"tcp"), (Object)"p-udp", (Object)PortMapping.of((int)1900, (Integer)2900, (String)"udp"));
        ImmutableMap registration = ImmutableMap.of((Object)ServiceEndpoint.of((String)"foo-service", (String)"tcp"), (Object)ServicePorts.of((String[])new String[]{"foo"}), (Object)ServiceEndpoint.of((String)"bar-service", (String)"http"), (Object)ServicePorts.of((String[])new String[]{"bar"}));
        ImmutableMap env = ImmutableMap.of((Object)"BAD", (Object)"f00d");
        ImmutableMap configuration = ImmutableMap.of((Object)"id", (Object)(name + ":" + "17"), (Object)"image", (Object)"spotify/busybox:latest", (Object)"ports", (Object)ports, (Object)"registration", (Object)registration, (Object)"env", (Object)env);
        Path file = this.temporaryFolder.newFile().toPath();
        Files.write(file, Json.asBytes((Object)configuration), new OpenOption[0]);
        String output = this.cli("create", "-q", "-f", file.toAbsolutePath().toString());
        JobId jobId = JobId.parse((String)CharMatcher.whitespace().trimFrom((CharSequence)output));
        Map jobs = (Map)client.jobs().get();
        Job job = (Job)jobs.get(jobId);
        Assert.assertEquals((Object)name, (Object)job.getId().getName());
        Assert.assertEquals((Object)"17", (Object)job.getId().getVersion());
        Assert.assertEquals((Object)ports, (Object)job.getPorts());
        Assert.assertEquals((Object)env, (Object)job.getEnv());
        Assert.assertEquals((Object)registration, (Object)job.getRegistration());
    }
}

