/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ExecCreation;
import com.spotify.docker.client.messages.Version;
import com.spotify.helios.MockServiceRegistrarRegistry;
import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.ExecHealthCheck;
import com.spotify.helios.common.descriptors.HealthCheck;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.HttpHealthCheck;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.common.descriptors.TcpHealthCheck;
import com.spotify.helios.common.protocol.TaskStatusEvents;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistration;
import com.spotify.helios.system.ServiceRegistrationTestBase;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class HealthCheckTest
extends ServiceRegistrationTestBase {
    @Mock
    public ServiceRegistrar registrar;
    @Captor
    public ArgumentCaptor<ServiceRegistration> registrationCaptor;
    private final String registryAddress = this.uniqueRegistryAddress();

    @Before
    public void setup() {
        MockServiceRegistrarRegistry.set((String)this.registryAddress, (ServiceRegistrar)this.registrar);
    }

    @After
    public void teardown() {
        MockServiceRegistrarRegistry.remove((String)this.registryAddress);
    }

    @Test
    public void testTcp() throws Exception {
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--service-registry=" + this.registryAddress);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        TcpHealthCheck healthCheck = TcpHealthCheck.of((String)"health");
        Job job = this.pokeJob((HealthCheck)healthCheck);
        this.assertContainerRegistersAfterPoke(client, job);
    }

    private void assertContainerRegistersAfterPoke(HeliosClient client, Job job) throws Exception {
        JobId jobId = this.createJob(job);
        this.deployJob(jobId, this.testHost());
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.HEALTHCHECKING);
        Thread.sleep(3000L);
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.never())).register((ServiceRegistration)Matchers.any(ServiceRegistration.class));
        this.pokeAndVerifyRegistration(client, jobId, 400);
        ServiceRegistration serviceRegistration = (ServiceRegistration)this.registrationCaptor.getValue();
        HashMap registered = Maps.newHashMap();
        for (ServiceRegistration.Endpoint endpoint : serviceRegistration.getEndpoints()) {
            registered.put(endpoint.getName(), endpoint);
        }
        Assert.assertEquals((String)"wrong service", (Object)"foo_service", (Object)((ServiceRegistration.Endpoint)registered.get("foo_service")).getName());
        Assert.assertEquals((String)"wrong protocol", (Object)"foo_proto", (Object)((ServiceRegistration.Endpoint)registered.get("foo_service")).getProtocol());
    }

    @Test
    public void testHttp() throws Exception {
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--service-registry=" + this.registryAddress);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        HttpHealthCheck healthCheck = HttpHealthCheck.of((String)"http", (String)"/");
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/nginx-alpine:latest").setCommand(Arrays.asList("sh", "-c", "nc -l -p 4711 && nginx -g 'daemon off;'")).addPort("poke", PortMapping.of((int)4711)).addPort("http", PortMapping.of((int)80)).addRegistration(ServiceEndpoint.of((String)"foo_service", (String)"foo_proto"), ServicePorts.of((String[])new String[]{"http"})).setHealthCheck((HealthCheck)healthCheck).build();
        this.assertContainerRegistersAfterPoke(client, job);
    }

    @Test
    public void testExec() throws Exception {
        Assume.assumeFalse((boolean)HealthCheckTest.isCircleCi());
        DockerClient dockerClient = this.getNewDockerClient();
        Assume.assumeThat((Object)dockerClient.version(), (Matcher)Is.is(HealthCheckTest.execCompatibleDockerVersion()));
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--service-registry=" + this.registryAddress);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        ExecHealthCheck healthCheck = ExecHealthCheck.of((String[])new String[]{"test", "-e", "file"});
        String portName = "service";
        String serviceName = "foo_service";
        String serviceProtocol = "foo_proto";
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(Arrays.asList("sh", "-c", "nc -l -p 4711")).addPort("service", PortMapping.of((int)4711)).addRegistration(ServiceEndpoint.of((String)"foo_service", (String)"foo_proto"), ServicePorts.of((String[])new String[]{"service"})).setHealthCheck((HealthCheck)healthCheck).build();
        JobId jobId = this.createJob(job);
        this.deployJob(jobId, this.testHost());
        TaskStatus jobState = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.HEALTHCHECKING);
        Thread.sleep(3000L);
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.never())).register((ServiceRegistration)Matchers.any(ServiceRegistration.class));
        String[] makeFileCmd = new String[]{"touch", "file"};
        ExecCreation execCreation = dockerClient.execCreate(jobState.getContainerId(), makeFileCmd, new DockerClient.ExecCreateParam[0]);
        String execId = execCreation.id();
        dockerClient.execStart(execId, new DockerClient.ExecStartParameter[0]);
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.RUNNING);
        dockerClient.close();
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(400L))))).register((ServiceRegistration)this.registrationCaptor.capture());
        ServiceRegistration serviceRegistration = (ServiceRegistration)this.registrationCaptor.getValue();
        Assert.assertEquals((long)1L, (long)serviceRegistration.getEndpoints().size());
        ServiceRegistration.Endpoint registeredEndpoint = (ServiceRegistration.Endpoint)serviceRegistration.getEndpoints().get(0);
        Assert.assertEquals((String)"wrong service", (Object)"foo_service", (Object)registeredEndpoint.getName());
        Assert.assertEquals((String)"wrong protocol", (Object)"foo_proto", (Object)registeredEndpoint.getProtocol());
    }

    private static Matcher<Version> execCompatibleDockerVersion() {
        return new CustomTypeSafeMatcher<Version>("apiVersion >= 1.18"){

            protected boolean matchesSafely(Version version) {
                try {
                    Iterator versionParts = Splitter.on((char)'.').split((CharSequence)version.apiVersion()).iterator();
                    int apiVersionMajor = Integer.parseInt((String)versionParts.next());
                    int apiVersionMinor = Integer.parseInt((String)versionParts.next());
                    return apiVersionMajor == 1 && apiVersionMinor >= 18;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
    }

    @Test
    public void testContainerDiesDuringHealthcheck() throws Exception {
        this.startDefaultMaster(new String[0]);
        final HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--service-registry=" + this.registryAddress);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        TcpHealthCheck healthCheck = TcpHealthCheck.of((String)"health");
        Job job = this.pokeJob((HealthCheck)healthCheck);
        final JobId jobId = this.createJob(job);
        this.deployJob(jobId, this.testHost());
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.HEALTHCHECKING);
        JobStatus jobStatus = (JobStatus)this.getOrNull(client.jobStatus(jobId));
        TaskStatus taskStatus = (TaskStatus)jobStatus.getTaskStatuses().get(this.testHost());
        this.getNewDockerClient().killContainer(taskStatus.getContainerId());
        int timeout = 40;
        Polling.await((long)40L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TaskStatusEvents jobHistory = (TaskStatusEvents)HealthCheckTest.this.getOrNull(client.jobHistory(jobId));
                for (TaskStatusEvent event : jobHistory.getEvents()) {
                    if (event.getStatus().getState() != TaskStatus.State.FAILED) continue;
                    return true;
                }
                return null;
            }
        });
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.HEALTHCHECKING);
        this.pokeAndVerifyRegistration(client, jobId, 40);
    }

    private void pokeAndVerifyRegistration(final HeliosClient client, final JobId jobId, int timeout) throws Exception {
        Polling.await((long)timeout, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JobStatus jobStatus = (JobStatus)HealthCheckTest.this.getOrNull(client.jobStatus(jobId));
                TaskStatus taskStatus = (TaskStatus)jobStatus.getTaskStatuses().get(HealthCheckTest.this.testHost());
                PortMapping port = (PortMapping)taskStatus.getPorts().get("poke");
                assert (port.getExternalPort() != null);
                if (HealthCheckTest.this.poke(port.getExternalPort())) {
                    return true;
                }
                return null;
            }
        });
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.RUNNING);
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(timeout))))).register((ServiceRegistration)this.registrationCaptor.capture());
    }

    private Job pokeJob(HealthCheck healthCheck) {
        return Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/alpine:latest").setCommand(Arrays.asList("sh", "-c", "nc -l -p 4711 && nc -lk -p 4712 -e hostname")).addPort("poke", PortMapping.of((int)4711)).addPort("health", PortMapping.of((int)4712)).addRegistration(ServiceEndpoint.of((String)"foo_service", (String)"foo_proto"), ServicePorts.of((String[])new String[]{"health"})).setHealthCheck(healthCheck).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean poke(int port) {
        try (Socket ignored = new Socket(DOCKER_HOST.address(), port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

