/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.helios.Polling;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class EnvironmentVariableTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), "--env", "SPOTIFY_POD=PODNAME", "SPOTIFY_ROLE=ROLENAME", "BAR=badfood");
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Map status = (Map)Json.read((String)EnvironmentVariableTest.this.cli("hosts", EnvironmentVariableTest.this.testHost(), "--json"), (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
                return ((HostStatus)status.get(EnvironmentVariableTest.this.testHost())).getEnvironment();
            }
        });
        try (DockerClient dockerClient = this.getNewDockerClient();){
            List<String> command = Arrays.asList("sh", "-c", "echo pod: $SPOTIFY_POD; echo role: $SPOTIFY_ROLE; echo foo: $FOO; echo bar: $BAR");
            JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", command, (ImmutableMap<String, String>)ImmutableMap.of((Object)"FOO", (Object)"4711", (Object)"BAR", (Object)"deadbeef"));
            this.deployJob(jobId, this.testHost());
            TaskStatus taskStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.EXITED);
            LogStream logs = dockerClient.logs(taskStatus.getContainerId(), new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
            String log = logs.readFully();
            MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"pod: PODNAME"));
            MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"role: ROLENAME"));
            MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"foo: 4711"));
            MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"bar: deadbeef"));
            Map status = (Map)Json.read((String)this.cli("hosts", this.testHost(), "--json"), (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
            Assert.assertEquals((Object)ImmutableMap.of((Object)"SPOTIFY_POD", (Object)"PODNAME", (Object)"SPOTIFY_ROLE", (Object)"ROLENAME", (Object)"BAR", (Object)"badfood"), (Object)((HostStatus)status.get(this.testHost())).getEnvironment());
            Assert.assertEquals((Object)ImmutableMap.of((Object)"SPOTIFY_POD", (Object)"PODNAME", (Object)"SPOTIFY_ROLE", (Object)"ROLENAME", (Object)"BAR", (Object)"deadbeef", (Object)"FOO", (Object)"4711"), (Object)((TaskStatus)((HostStatus)status.get(this.testHost())).getStatuses().get(jobId)).getEnv());
        }
    }
}

