/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.common.protocol.TaskStatusEvents;
import com.spotify.helios.system.SystemTestBase;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class JobHistoryTest
extends SystemTestBase {
    @Test
    public void testJobHistory() throws Exception {
        this.startDefaultMaster(new String[0]);
        final HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        final JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", IDLE_COMMAND);
        this.deployJob(jobId, this.testHost());
        this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.undeployJob(jobId, this.testHost());
        this.awaitTaskGone(client, this.testHost(), jobId, 400L, TimeUnit.SECONDS);
        TaskStatusEvents events = (TaskStatusEvents)Polling.await((long)40L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<TaskStatusEvents>(){

            @Override
            public TaskStatusEvents call() throws Exception {
                TaskStatusEvents events = (TaskStatusEvents)client.jobHistory(jobId).get();
                int size = events.getEvents().size();
                if (size == 0) {
                    return null;
                }
                int requiredEventCount = -1;
                for (int i = 0; i < size; ++i) {
                    if (((TaskStatusEvent)events.getEvents().get(i)).getStatus().getState() == TaskStatus.State.PULLING_IMAGE) continue;
                    requiredEventCount = i + 5;
                    break;
                }
                if (requiredEventCount == -1) {
                    return null;
                }
                if (size < requiredEventCount) {
                    return null;
                }
                return events;
            }
        });
        ListIterator it = events.getEvents().listIterator();
        while (true) {
            TaskStatusEvent event;
            if ((event = (TaskStatusEvent)it.next()).getStatus().getState() != TaskStatus.State.PULLING_IMAGE) break;
            Assert.assertThat((Object)event, (Matcher)Matchers.not(JobHistoryTest.hasContainerId()));
        }
        it.previous();
        Assert.assertThat(it.next(), (Matcher)Matchers.allOf(JobHistoryTest.hasState(TaskStatus.State.CREATING), (Matcher)Matchers.not(JobHistoryTest.hasContainerId())));
        Assert.assertThat(it.next(), (Matcher)Matchers.allOf(JobHistoryTest.hasState(TaskStatus.State.STARTING), JobHistoryTest.hasContainerId()));
        Assert.assertThat(it.next(), JobHistoryTest.hasState(TaskStatus.State.RUNNING));
        Assert.assertThat(it.next(), JobHistoryTest.hasState(TaskStatus.State.STOPPING));
        Assert.assertThat(it.next(), JobHistoryTest.hasState(TaskStatus.State.EXITED, TaskStatus.State.STOPPED));
    }

    @Test
    public void testJobHistoryDisabled() throws Exception {
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--disable-job-history");
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", IDLE_COMMAND);
        this.deployJob(jobId, this.testHost());
        this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.undeployJob(jobId, this.testHost());
        this.awaitTaskGone(client, this.testHost(), jobId, 400L, TimeUnit.SECONDS);
    }

    private static Matcher<TaskStatusEvent> hasState(final TaskStatus.State ... possibleStates) {
        String description = "TaskStatusEvent with status.state in " + Arrays.toString(possibleStates);
        return new CustomTypeSafeMatcher<TaskStatusEvent>(description){

            protected boolean matchesSafely(TaskStatusEvent event) {
                TaskStatus.State actual = event.getStatus().getState();
                for (TaskStatus.State state : possibleStates) {
                    if (state != actual) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static Matcher<TaskStatusEvent> hasContainerId() {
        return new CustomTypeSafeMatcher<TaskStatusEvent>("a non-null status.containerId"){

            protected boolean matchesSafely(TaskStatusEvent item) {
                return item.getStatus().getContainerId() != null;
            }
        };
    }
}

