/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyslogRedirectionTest
extends SystemTestBase {
    private static final Pattern DEFAULT_GATEWAY_PATTERN = Pattern.compile("^default via (?<gateway>[0-9\\.]+)");
    private final String testImage;
    private String syslogHost;

    public SyslogRedirectionTest() {
        this.testImage = this.testTag + "_helios-syslog-test";
    }

    @Before
    public void setup() throws Exception {
        try (DockerClient docker = this.getNewDockerClient();){
            String log;
            String dockerDirectory = Resources.getResource((String)"syslog-test-image").getPath();
            docker.build(Paths.get(dockerDirectory, new String[0]), this.testImage, new DockerClient.BuildParam[0]);
            ContainerConfig config = ContainerConfig.builder().image("busybox:latest").cmd(Arrays.asList("ip", "route", "show")).build();
            ContainerCreation creation = docker.createContainer(config);
            String containerId = creation.id();
            docker.startContainer(containerId);
            docker.waitContainer(containerId);
            try (LogStream logs = docker.logs(containerId, new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});){
                log = logs.readFully();
            }
            java.util.regex.Matcher m = DEFAULT_GATEWAY_PATTERN.matcher(log);
            if (m.find()) {
                this.syslogHost = m.group("gateway");
            } else {
                Assert.fail((String)("couldn't determine the host address from '" + log + "'"));
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        try (DockerClient docker = this.getNewDockerClient();){
            try {
                docker.removeImage(this.testImage, true, false);
            }
            catch (DockerException dockerException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        String syslogOutput = "should-be-redirected";
        try (DockerClient docker = this.getNewDockerClient();){
            String log;
            String port = "4711";
            String expose = "4711/udp";
            docker.pull("onescience/alpine:latest");
            HostConfig hostConfig = HostConfig.builder().publishAllPorts(Boolean.valueOf(true)).build();
            ContainerConfig config = ContainerConfig.builder().image("onescience/alpine:latest").cmd(Arrays.asList("nc", "-p", "4711", "-l", "-u")).exposedPorts((Set)ImmutableSet.of((Object)"4711/udp")).hostConfig(hostConfig).build();
            ContainerCreation creation = docker.createContainer(config, this.testTag + "_syslog");
            String syslogContainerId = creation.id();
            docker.startContainer(syslogContainerId);
            ContainerInfo containerInfo = docker.inspectContainer(syslogContainerId);
            Assert.assertThat((Object)containerInfo.state().running(), (Matcher)Matchers.equalTo((Object)true));
            String syslogEndpoint = this.syslogHost + ":" + ((PortBinding)((List)containerInfo.networkSettings().ports().get("4711/udp")).get(0)).hostPort();
            this.startDefaultMaster(new String[0]);
            this.startDefaultAgent(this.testHost(), "--syslog-redirect", syslogEndpoint);
            this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
            ArrayList command = Lists.newArrayList();
            JobId jobId = this.createJob(this.testJobName, this.testJobVersion, this.testImage, (List<String>)command, (ImmutableMap<String, String>)ImmutableMap.of((Object)"SYSLOG_REDIRECTOR", (Object)"/syslog-redirector"));
            this.deployJob(jobId, this.testHost());
            TaskStatus taskStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.EXITED);
            try (LogStream logs = null;){
                logs = docker.logs(taskStatus.getContainerId(), new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
                String log2 = logs.readFully();
                Assert.assertEquals((Object)"", (Object)log2);
            }
            try (LogStream logs = docker.logs(syslogContainerId, new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});){
                log = logs.readFully();
            }
            Assert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"should-be-redirected"));
        }
    }
}

