/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.common.Json;
import com.spotify.helios.common.protocol.VersionResponse;
import com.spotify.helios.system.SystemTestBase;
import org.junit.Assert;
import org.junit.Test;

public class VersionCommandTest
extends SystemTestBase {
    @Test
    public void testReadableVersion() throws Exception {
        this.startDefaultMaster(new String[0]);
        String response = this.main("version", "-z", this.masterEndpoint()).toString();
        String regexp = String.format("(?s).*%s.*%s.*", "0.9.70", "0.9.70");
        Assert.assertTrue((String)("response does not contain two version numbers - \n" + response), (boolean)response.matches(regexp));
    }

    @Test
    public void testJsonVersion() throws Exception {
        this.startDefaultMaster(new String[0]);
        VersionResponse version = this.getVersion("version", "--json", "-z", this.masterEndpoint());
        Assert.assertEquals((String)"wrong client version", (Object)"0.9.70", (Object)version.getClientVersion());
        Assert.assertEquals((String)"wrong master version", (Object)"0.9.70", (Object)version.getMasterVersion());
    }

    @Test
    public void testVersionWithServerError() throws Exception {
        this.startDefaultMaster(new String[0]);
        VersionResponse version = this.getVersion("version", "--json", "-z", this.masterEndpoint() + "/badPath");
        Assert.assertEquals((String)"wrong client version", (Object)"0.9.70", (Object)version.getClientVersion());
        Assert.assertEquals((String)"wrong master version", (Object)"Master replied with error code 404", (Object)version.getMasterVersion());
    }

    private VersionResponse getVersion(String ... args) throws Exception {
        String response = this.main(args).toString();
        return (VersionResponse)Json.read((String)response, VersionResponse.class);
    }
}

