/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Container;
import com.spotify.helios.Polling;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class AgentZooKeeperDownTolerationTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        final DockerClient dockerClient = this.getNewDockerClient();
        final HeliosClient client = this.defaultClient();
        AgentMain agent1 = this.startDefaultAgent(this.testHost(), new String[0]);
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("spotify/busybox:latest").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        final JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        this.awaitHostRegistered(client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        TaskStatus firstTaskStatus = this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.assertJobEquals(job, firstTaskStatus.getJob());
        Assert.assertNotNull((Object)dockerClient.inspectContainer(firstTaskStatus.getContainerId()));
        this.zk().stop();
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)dockerClient.inspectContainer(firstTaskStatus.getContainerId()).state().running());
        agent1.stopAsync().awaitTerminated();
        AgentMain agent2 = this.startDefaultAgent(this.testHost(), new String[0]);
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)dockerClient.inspectContainer(firstTaskStatus.getContainerId()).state().running());
        dockerClient.killContainer(firstTaskStatus.getContainerId());
        Assert.assertFalse((boolean)dockerClient.inspectContainer(firstTaskStatus.getContainerId()).state().running());
        String firstRestartedContainerId = (String)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                List<Container> containers = AgentZooKeeperDownTolerationTest.this.listContainers(dockerClient, AgentZooKeeperDownTolerationTest.this.testTag);
                return containers.size() == 1 ? containers.get(0).id() : null;
            }
        });
        agent2.stopAsync().awaitTerminated();
        dockerClient.killContainer(firstRestartedContainerId);
        Assert.assertFalse((boolean)dockerClient.inspectContainer(firstRestartedContainerId).state().running());
        this.startDefaultAgent(this.testHost(), new String[0]);
        final String secondRestartedContainerId = (String)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                List<Container> containers = AgentZooKeeperDownTolerationTest.this.listContainers(dockerClient, AgentZooKeeperDownTolerationTest.this.testTag);
                return containers.size() == 1 ? containers.get(0).id() : null;
            }
        });
        Assert.assertTrue((boolean)dockerClient.inspectContainer(secondRestartedContainerId).state().running());
        this.zk().start();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                JobStatus jobStatus = (JobStatus)client.jobStatus(jobId).get();
                TaskStatus taskStatus = (TaskStatus)jobStatus.getTaskStatuses().get(AgentZooKeeperDownTolerationTest.this.testHost());
                return taskStatus != null && Objects.equals(taskStatus.getContainerId(), secondRestartedContainerId) ? taskStatus : null;
            }
        });
    }
}

