/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.Polling;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CliHostListTest
extends SystemTestBase {
    private String hostname1;
    private String hostname2;

    @Before
    public void initialize() throws Exception {
        this.startDefaultMaster(new String[0]);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String output = CliHostListTest.this.cli("masters", new String[0]);
                return output.contains(CliHostListTest.this.masterName()) ? output : null;
            }
        });
        this.hostname1 = this.testHost() + "a";
        this.hostname2 = this.testHost() + "b";
        this.startDefaultAgent(this.hostname1, new String[0]);
        AgentMain agent2 = this.startDefaultAgent(this.hostname2, new String[0]);
        this.awaitHostRegistered(this.hostname1, 400L, TimeUnit.SECONDS);
        this.awaitHostStatus(this.hostname2, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        agent2.stopAsync().awaitTerminated();
    }

    @Test
    public void testHostListJson() throws Exception {
        String jsonOutput = this.cli("hosts", "-f", "--json");
        Map statuses = (Map)Json.readUnchecked((String)jsonOutput, (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
        HeliosClient client = this.defaultClient();
        Map expectedStatuses = (Map)client.hostStatuses((List)ImmutableList.of((Object)this.hostname1, (Object)this.hostname2)).get();
        Assert.assertThat((Object)expectedStatuses, (Matcher)Matchers.equalTo((Object)statuses));
    }

    @Test
    public void testStatusFilter() throws Exception {
        String jsonOutput = this.cli("hosts", "-f", "--json", "--status", "UP");
        Map statuses = (Map)Json.readUnchecked((String)jsonOutput, (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
        HeliosClient client = this.defaultClient();
        Map expectedStatuses = (Map)client.hostStatuses((List)ImmutableList.of((Object)this.hostname1)).get();
        Assert.assertThat((Object)expectedStatuses, (Matcher)Matchers.equalTo((Object)statuses));
        jsonOutput = this.cli("hosts", "-f", "--json", "--status", "DOWN");
        statuses = (Map)Json.readUnchecked((String)jsonOutput, (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
        expectedStatuses = (Map)client.hostStatuses((List)ImmutableList.of((Object)this.hostname2)).get();
        Assert.assertThat((Object)expectedStatuses, (Matcher)Matchers.equalTo((Object)statuses));
    }

    @Test(expected=ArgumentParserException.class)
    public void testInvalidStatus() throws Exception {
        this.cli("hosts", "-f", "--json", "--status", "up");
    }
}

