/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.cli.Target;
import com.spotify.helios.client.HeliosClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class Utils {
    public static <K, V> Map<K, V> allAsMap(Map<K, ListenableFuture<V>> map) throws ExecutionException, InterruptedException {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<K, ListenableFuture<V>> e : map.entrySet()) {
            result.put(e.getKey(), e.getValue().get());
        }
        return result;
    }

    public static HeliosClient getClient(Target target, PrintStream err, String username) {
        List endpoints = Collections.emptyList();
        try {
            endpoints = (List)target.getEndpointSupplier().get();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (endpoints.size() == 0) {
            err.println("Failed to resolve helios master in " + target);
            return null;
        }
        return HeliosClient.newBuilder().setEndpointSupplier(target.getEndpointSupplier()).setUser(username).build();
    }

    public static boolean userConfirmed(PrintStream out, BufferedReader stdin) throws IOException {
        out.printf("Do you want to continue? [y/N]%n", new Object[0]);
        String line = stdin.readLine().trim();
        if (line.length() < 1) {
            return false;
        }
        char c = line.charAt(0);
        return c == 'Y' || c == 'y';
    }
}

