/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.spotify.helios.cli.command.WildcardJobCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServicePorts;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobInspectCommand
extends WildcardJobCommand {
    private static final Function<String, String> QUOTE = new Function<String, String>(){

        public String apply(String input) {
            return JobInspectCommand.quote(input);
        }
    };
    private static final Function<PortMapping, String> FORMAT_PORTMAPPING = new Function<PortMapping, String>(){

        public String apply(PortMapping input) {
            String s = String.valueOf(input.getInternalPort());
            if (input.getExternalPort() != null) {
                s = s + ":" + input.getExternalPort();
            }
            if (input.getProtocol() != null) {
                s = s + "/" + input.getProtocol();
            }
            return s;
        }
    };
    private static final Function<ServicePorts, String> FORMAT_SERVICE_PORTS = new Function<ServicePorts, String>(){

        public String apply(ServicePorts input) {
            return Joiner.on((String)", ").join((Iterable)Ordering.natural().sortedCopy(input.getPorts().keySet()));
        }
    };

    public JobInspectCommand(Subparser parser) {
        super(parser);
        parser.help("print the configuration of a job");
    }

    @Override
    protected int runWithJobId(Namespace options, HeliosClient client, PrintStream out, boolean json, JobId jobId, BufferedReader stdin) throws ExecutionException, InterruptedException {
        Map jobs = (Map)client.jobs(jobId.toString()).get();
        if (jobs.size() == 0) {
            out.printf("Unknown job: %s%n", jobId);
            return 1;
        }
        Job job = (Job)Iterables.getOnlyElement(jobs.values());
        if (json) {
            out.println(Json.asPrettyStringUnchecked((Object)job));
        } else {
            out.printf("Id: %s%n", job.getId());
            out.printf("Image: %s%n", job.getImage());
            out.printf("Token: %s%n", job.getToken());
            out.printf("Command: %s%n", JobInspectCommand.quote(job.getCommand()));
            this.printMap(out, "Env:   ", QUOTE, job.getEnv());
            this.printMap(out, "Ports: ", FORMAT_PORTMAPPING, job.getPorts());
            this.printMap(out, "Reg: ", FORMAT_SERVICE_PORTS, job.getRegistration());
            out.printf("Grace period (seconds): %s%n", job.getGracePeriod());
            this.printVolumes(out, job.getVolumes());
        }
        return 0;
    }

    private <K extends Comparable<K>, V> void printMap(PrintStream out, String name, Function<V, String> transform, Map<K, V> values) {
        out.print(name);
        boolean first = true;
        for (Comparable key : Ordering.natural().sortedCopy(values.keySet())) {
            if (!first) {
                out.print(Strings.repeat((String)" ", (int)name.length()));
            }
            V value = values.get(key);
            out.printf("%s=%s%n", key, transform.apply(value));
            first = false;
        }
        if (first) {
            out.println();
        }
    }

    private void printVolumes(PrintStream out, Map<String, String> volumes) {
        String prefix = "Volumes: ";
        out.print("Volumes: ");
        boolean first = true;
        for (Map.Entry<String, String> entry : volumes.entrySet()) {
            if (!first) {
                out.print(Strings.repeat((String)" ", (int)"Volumes: ".length()));
            }
            String path = entry.getValue();
            String source = entry.getKey();
            if (source == null) {
                out.printf("%s%n", path);
            } else {
                out.printf("%s:%s%n", path, source);
            }
            first = false;
        }
        if (first) {
            out.println();
        }
    }

    private static String quote(String s) {
        if (s == null) {
            return "";
        }
        return CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)s) ? '\"' + s + '\"' : s;
    }

    private static List<String> quote(List<String> ss) {
        ArrayList output = Lists.newArrayList();
        for (String s : ss) {
            output.add(JobInspectCommand.quote(s));
        }
        return output;
    }
}

