/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.WildcardJobCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRemoveCommand
extends WildcardJobCommand {
    private static final Logger log = LoggerFactory.getLogger(JobRemoveCommand.class);
    private final Argument tokenArg;
    private final Argument yesArg;
    private final Argument forceArg;

    public JobRemoveCommand(Subparser parser) {
        super(parser);
        parser.help("remove a job");
        this.tokenArg = parser.addArgument(new String[]{"--token"}).nargs("?").setDefault((Object)"").help("Insecure access token");
        this.yesArg = parser.addArgument(new String[]{"--yes"}).action((ArgumentAction)Arguments.storeTrue()).help("Automatically answer 'yes' to the interactive prompt.");
        this.forceArg = parser.addArgument(new String[]{"--force"}).action((ArgumentAction)Arguments.storeTrue()).help("Automatically answer 'yes' to the interactive prompt.");
    }

    @Override
    protected int runWithJobId(Namespace options, HeliosClient client, PrintStream out, boolean json, JobId jobId, BufferedReader stdin) throws IOException, ExecutionException, InterruptedException {
        boolean yes = options.getBoolean(this.yesArg.getDest());
        boolean force = options.getBoolean(this.forceArg.getDest());
        if (force) {
            log.warn("If you are using '--force' to skip the interactive prompt, note that we have deprecated it. Please use '--yes'.");
        }
        if (!yes && !force) {
            out.printf("This will remove the job %s%n", jobId);
            boolean confirmed = Utils.userConfirmed(out, stdin);
            if (!confirmed) {
                return 1;
            }
        }
        if (!json) {
            out.printf("Removing job %s%n", jobId);
        }
        int code = 0;
        String token = options.getString(this.tokenArg.getDest());
        JobDeleteResponse response = (JobDeleteResponse)client.deleteJob(jobId, token).get();
        if (!json) {
            out.printf("%s: ", jobId);
        }
        if (response.getStatus() == JobDeleteResponse.Status.OK) {
            if (json) {
                out.printf(response.toJsonString(), new Object[0]);
            } else {
                out.printf("done%n", new Object[0]);
            }
        } else {
            if (json) {
                out.printf(response.toJsonString(), new Object[0]);
            } else {
                out.printf("failed: %s%n", response);
            }
            code = 1;
        }
        return code;
    }
}

