/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.cli.Target;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.JobStatusFetcher;
import com.spotify.helios.cli.command.MultiTargetControlCommand;
import com.spotify.helios.cli.command.TargetAndClient;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.TaskStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JobWatchCommand
extends MultiTargetControlCommand {
    private final Argument prefixesArg;
    private final Argument jobsArg;
    private final Argument intervalArg;
    private final Argument exactArg;

    public JobWatchCommand(Subparser parser) {
        super(parser);
        parser.help("watch jobs");
        this.jobsArg = parser.addArgument(new String[]{"job"}).help("Job reference");
        this.intervalArg = parser.addArgument(new String[]{"--interval"}).setDefault((Object)1).help("polling interval, default 1 second");
        this.prefixesArg = parser.addArgument(new String[]{"hosts"}).nargs("*").help("The hostname prefixes to watch the job on.");
        this.exactArg = parser.addArgument(new String[]{"--exact"}).action((ArgumentAction)Arguments.storeTrue()).help("Show status of job for every host in hosts");
    }

    @Override
    int run(Namespace options, List<TargetAndClient> clients, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        boolean exact = options.getBoolean(this.exactArg.getDest());
        List prefixes = options.getList(this.prefixesArg.getDest());
        String jobIdString = options.getString(this.jobsArg.getDest());
        ArrayList jobIdFutures = Lists.newArrayList();
        for (TargetAndClient cc : clients) {
            jobIdFutures.add(cc.getClient().jobs(jobIdString));
        }
        HashSet jobIds = Sets.newHashSet();
        for (ListenableFuture future : jobIdFutures) {
            jobIds.addAll(((Map)future.get()).keySet());
        }
        JobWatchCommand.watchJobsOnHosts(out, exact, (List<String>)prefixes, jobIds, (int)options.getInt(this.intervalArg.getDest()), clients);
        return 0;
    }

    public static void watchJobsOnHosts(PrintStream out, boolean exact, List<String> resolvedHosts, List<JobId> jobIds, Integer interval, HeliosClient client) throws InterruptedException, ExecutionException {
        JobWatchCommand.watchJobsOnHosts(out, exact, resolvedHosts, Sets.newHashSet(jobIds), (int)interval, (List<TargetAndClient>)ImmutableList.of((Object)new TargetAndClient(client)));
    }

    static void watchJobsOnHosts(PrintStream out, boolean exact, List<String> prefixes, Set<JobId> jobIds, int interval, List<TargetAndClient> clients) throws InterruptedException, ExecutionException {
        out.println("Control-C to stop");
        out.println("JOB                  HOST                           STATE    THROTTLED?");
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss");
        while (true) {
            Instant now = new Instant();
            out.printf("-------------------- ------------------------------ -------- ---------- [%s UTC]%n", now.toString(formatter));
            for (TargetAndClient cc : clients) {
                Optional<Target> target = cc.getTarget();
                if (clients.size() > 1) {
                    String header;
                    if (target.isPresent()) {
                        List endpoints = (List)((Target)target.get()).getEndpointSupplier().get();
                        header = String.format(" %s (%s)", ((Target)target.get()).getName(), endpoints);
                    } else {
                        header = "";
                    }
                    out.printf("---%s%n", header);
                }
                JobWatchCommand.showReport(out, exact, prefixes, jobIds, formatter, cc.getClient());
            }
            if (out.checkError()) break;
            Thread.sleep(1000 * interval);
        }
    }

    private static void showReport(PrintStream out, boolean exact, List<String> prefixes, Set<JobId> jobIds, DateTimeFormatter formatter, HeliosClient client) throws ExecutionException, InterruptedException {
        Map<JobId, JobStatus> statuses = JobWatchCommand.getStatuses(client, jobIds);
        for (JobId jobId : jobIds) {
            TaskStatus ts;
            JobStatus jobStatus = statuses.get(jobId);
            if (jobStatus == null) continue;
            Map taskStatuses = jobStatus.getTaskStatuses();
            if (exact) {
                for (String host : prefixes) {
                    ts = (TaskStatus)taskStatuses.get(host);
                    out.printf("%-20s %-30s %-8s %s%n", JobWatchCommand.chop(jobId.toShortString(), 20), JobWatchCommand.chop(host, 30), ts != null ? ts.getState() : "UNKNOWN", ts != null ? ts.getThrottled() : "UNKNOWN");
                }
                continue;
            }
            for (String host : taskStatuses.keySet()) {
                if (!JobWatchCommand.hostMatches(prefixes, host)) continue;
                ts = (TaskStatus)taskStatuses.get(host);
                out.printf("%-20s %-30s %-8s %s%n", JobWatchCommand.chop(jobId.toShortString(), 20), JobWatchCommand.chop(host, 30), ts.getState(), ts.getThrottled());
            }
        }
    }

    private static boolean hostMatches(List<String> prefixes, String host) {
        if (prefixes.isEmpty()) {
            return true;
        }
        for (String prefix : prefixes) {
            if (!host.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static String chop(String s, int len) {
        if (s.length() <= len) {
            return s;
        }
        return s.substring(0, len);
    }

    private static Map<JobId, JobStatus> getStatuses(HeliosClient client, Set<JobId> jobIds) throws ExecutionException, InterruptedException {
        Map<JobId, ListenableFuture<JobStatus>> futures = JobStatusFetcher.getJobsStatuses(client, jobIds);
        TreeMap statuses = Maps.newTreeMap();
        statuses.putAll(Utils.allAsMap(futures));
        return statuses;
    }
}

