/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.JobValidator;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.ExecHealthCheck;
import com.spotify.helios.common.descriptors.HealthCheck;
import com.spotify.helios.common.descriptors.HttpHealthCheck;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.descriptors.TcpHealthCheck;
import com.spotify.helios.common.protocol.CreateJobResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.joda.time.DateTime;

public class JobCreateCommand
extends ControlCommand {
    private static final JobValidator JOB_VALIDATOR = new JobValidator();
    private final Argument fileArg;
    private final Argument templateArg;
    private final Argument quietArg;
    private final Argument idArg;
    private final Argument imageArg;
    private final Argument tokenArg;
    private final Argument envArg;
    private final Argument argsArg;
    private final Argument portArg;
    private final Argument registrationArg;
    private final Argument registrationDomainArg;
    private final Argument gracePeriodArg;
    private final Argument volumeArg;
    private final Argument expiresArg;
    private final Argument healthCheckExecArg;
    private final Argument healthCheckHttpArg;
    private final Argument healthCheckTcpArg;

    public JobCreateCommand(Subparser parser) {
        super(parser);
        parser.help("create a job");
        this.fileArg = parser.addArgument(new String[]{"-f", "--file"}).type((ArgumentType)Arguments.fileType().acceptSystemIn()).help("Job configuration file. Options specified on the command line will be merged with the contents of this file. Cannot be used together with -t/--template.");
        this.templateArg = parser.addArgument(new String[]{"-t", "--template"}).help("Template job id. The new job will be based on this job. Cannot be used together with -f/--file.");
        this.quietArg = parser.addArgument(new String[]{"-q"}).action((ArgumentAction)Arguments.storeTrue()).help("only print job id");
        this.idArg = parser.addArgument(new String[]{"id"}).nargs("?").help("Job name:version[:hash]");
        this.imageArg = parser.addArgument(new String[]{"image"}).nargs("?").help("Container image");
        this.tokenArg = parser.addArgument(new String[]{"--token"}).nargs("?").setDefault((Object)"").help("Insecure access token meant to prevent accidental changes to your job (e.g. undeploys).");
        this.envArg = parser.addArgument(new String[]{"--env"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("Environment variables");
        this.portArg = parser.addArgument(new String[]{"-p", "--port"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("Port mapping. Specify an endpoint name and a single port (e.g. \"http=8080\") for dynamic port mapping and a name=private:public tuple (e.g. \"http=8080:80\") for static port mapping. E.g., foo=4711 will map the internal port 4711 of the container to an arbitrary external port on the host. Specifying foo=4711:80 will map internal port 4711 of the container to port 80 on the host. The protocol will be TCP by default. For UDP, add /udp. E.g. quic=80/udp or dns=53:53/udp. The endpoint name can be used when specifying service registration using -r/--register.");
        this.registrationArg = parser.addArgument(new String[]{"-r", "--register"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("Service discovery registration. Specify a service name, the port name and a protocol on the format service/protocol=port. E.g. -r website/tcp=http will register the port named http with the protocol tcp. Protocol is optional and default is tcp. If there is only one port mapping, this will be used by default and it will be enough to specify only the service name, e.g. -r wordpress.");
        this.registrationDomainArg = parser.addArgument(new String[]{"--registration-domain"}).setDefault((Object)"").help("If set, overrides the default domain in which discovery serviceregistration occurs. What is allowed here will vary based upon the discovery service plugin used.");
        this.gracePeriodArg = parser.addArgument(new String[]{"--grace-period"}).type(Integer.class).setDefault(null).help("if --grace-period is specified, Helios will unregister from service discovery and wait the specified number of seconds before undeploying, default 0 seconds");
        this.volumeArg = parser.addArgument(new String[]{"--volume"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("Container volumes. Specify either a single path to create a data volume, or a source path and a container path to mount a file or directory from the host. The container path can be suffixed with \"rw\" or \"ro\" to create a read-write or read-only volume, respectively. Format: [host-path]:[container-path]:[rw|ro].");
        this.argsArg = parser.addArgument(new String[]{"args"}).nargs("*").help("Command line arguments");
        this.expiresArg = parser.addArgument(new String[]{"-e", "--expires"}).help("An ISO-8601 string representing the date/time when this job should expire. The job will be undeployed from all hosts and removed at this time. E.g. 2014-06-01T12:00:00Z");
        this.healthCheckExecArg = parser.addArgument(new String[]{"--exec-check"}).help("Run `docker exec` health check with the provided command. The service will not be registered in service discovery until the command executes successfully. E.g. --exec-check 'bash -c \"/usr/bin/curl 127.0.0.1:9200/_cluster/health?pretty=true | grep green\"'");
        this.healthCheckHttpArg = parser.addArgument(new String[]{"--http-check"}).help("Run HTTP health check against the provided port name and path. The service will not be registered in service discovery until the container passes the HTTP health check. Format: [port name]:[path].");
        this.healthCheckTcpArg = parser.addArgument(new String[]{"--tcp-check"}).help("Run TCP health check against the provided port name. The service will not be registered in service discovery until the container passes the TCP health check.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        CreateJobResponse status;
        List envList;
        List command;
        Job.Builder builder;
        boolean quiet = options.getBoolean(this.quietArg.getDest());
        String id = options.getString(this.idArg.getDest());
        String imageIdentifier = options.getString(this.imageArg.getDest());
        String templateJobId = options.getString(this.templateArg.getDest());
        File file = (File)options.get(this.fileArg.getDest());
        if (file != null && templateJobId != null) {
            throw new IllegalArgumentException("Please use only one of -t/--template and -f/--file");
        }
        if (file != null && file.exists()) {
            if (!file.isFile() || !file.canRead()) {
                throw new IllegalArgumentException("Cannot read file " + file);
            }
            byte[] bytes = Files.readAllBytes(file.toPath());
            String config = new String(bytes, Charsets.UTF_8);
            Job job = (Job)Json.read((String)config, Job.class);
            builder = job.toBuilder();
        } else if (templateJobId != null) {
            Map jobs = (Map)client.jobs(templateJobId).get();
            if (jobs.size() == 0) {
                if (!json) {
                    out.printf("Unknown job: %s%n", templateJobId);
                } else {
                    CreateJobResponse createJobResponse = new CreateJobResponse(CreateJobResponse.Status.UNKNOWN_JOB, null, null);
                    out.printf(createJobResponse.toJsonString(), new Object[0]);
                }
                return 1;
            }
            if (jobs.size() > 1) {
                if (!json) {
                    out.printf("Ambiguous job reference: %s%n", templateJobId);
                } else {
                    CreateJobResponse createJobResponse = new CreateJobResponse(CreateJobResponse.Status.AMBIGUOUS_JOB_REFERENCE, null, null);
                    out.printf(createJobResponse.toJsonString(), new Object[0]);
                }
                return 1;
            }
            Job template = (Job)Iterables.getOnlyElement(jobs.values());
            builder = template.toBuilder();
            if (id == null) {
                throw new IllegalArgumentException("Please specify new job name and version");
            }
        } else {
            if (id == null || imageIdentifier == null) {
                throw new IllegalArgumentException("Please specify a file, or a template, or a job name, version and container image");
            }
            builder = Job.newBuilder();
        }
        if (id != null) {
            String[] parts = id.split(":");
            switch (parts.length) {
                case 3: {
                    builder.setHash(parts[2]);
                }
                case 2: {
                    builder.setVersion(parts[1]);
                }
                case 1: {
                    builder.setName(parts[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Job id: " + id);
                }
            }
        }
        if (imageIdentifier != null) {
            builder.setImage(imageIdentifier);
        }
        if ((command = options.getList(this.argsArg.getDest())) != null && !command.isEmpty()) {
            builder.setCommand(command);
        }
        if (!(envList = options.getList(this.envArg.getDest())).isEmpty()) {
            HashMap env = Maps.newHashMap();
            env.putAll(builder.getEnv());
            for (String s : envList) {
                String[] parts = s.split("=", 2);
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Bad environment variable: " + s);
                }
                env.put(parts[0], parts[1]);
            }
            builder.setEnv((Map)env);
        }
        List portSpecs = options.getList(this.portArg.getDest());
        HashMap explicitPorts = Maps.newHashMap();
        Pattern portPattern = Pattern.compile("(?<n>[_\\-\\w]+)=(?<i>\\d+)(:(?<e>\\d+))?(/(?<p>\\w+))?");
        for (String spec : portSpecs) {
            Matcher matcher = portPattern.matcher(spec);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Bad port mapping: " + spec);
            }
            String portName = matcher.group("n");
            int internal = Integer.parseInt(matcher.group("i"));
            Integer external = this.nullOrInteger(matcher.group("e"));
            String protocol = (String)Optional.fromNullable((Object)matcher.group("p")).or((Object)"tcp");
            if (explicitPorts.containsKey(portName)) {
                throw new IllegalArgumentException("Duplicate port mapping: " + portName);
            }
            explicitPorts.put(portName, PortMapping.of((int)internal, (Integer)external, (String)protocol));
        }
        HashMap ports = Maps.newHashMap();
        ports.putAll(builder.getPorts());
        ports.putAll(explicitPorts);
        builder.setPorts((Map)ports);
        HashMap explicitRegistration = Maps.newHashMap();
        Pattern registrationPattern = Pattern.compile("(?<srv>[a-zA-Z][_\\-\\w]+)(?:/(?<prot>\\w+))?(?:=(?<port>[_\\-\\w]+))?");
        List registrationSpecs = options.getList(this.registrationArg.getDest());
        for (String spec : registrationSpecs) {
            String port;
            Matcher matcher = registrationPattern.matcher(spec);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Bad registration: " + spec);
            }
            String service = matcher.group("srv");
            String proto = (String)Optional.fromNullable((Object)matcher.group("prot")).or((Object)"http");
            String optionalPort = matcher.group("port");
            if (ports.size() == 0) {
                throw new IllegalArgumentException("Need port mappings for service registration.");
            }
            if (optionalPort == null) {
                if (ports.size() != 1) {
                    throw new IllegalArgumentException("Need exactly one port mapping for implicit service registration");
                }
                port = (String)Iterables.getLast(ports.keySet());
            } else {
                port = optionalPort;
            }
            explicitRegistration.put(ServiceEndpoint.of((String)service, (String)proto), ServicePorts.of((String[])new String[]{port}));
        }
        builder.setRegistrationDomain(options.getString(this.registrationDomainArg.getDest()));
        HashMap registration = Maps.newHashMap();
        registration.putAll(builder.getRegistration());
        registration.putAll(explicitRegistration);
        builder.setRegistration((Map)registration);
        Integer gracePeriod = options.getInt(this.gracePeriodArg.getDest());
        if (gracePeriod != null) {
            builder.setGracePeriod(gracePeriod);
        }
        List volumeSpecs = options.getList(this.volumeArg.getDest());
        block12: for (String spec : volumeSpecs) {
            String[] parts = spec.split(":", 2);
            switch (parts.length) {
                case 1: {
                    builder.addVolume(parts[0]);
                    continue block12;
                }
                case 2: {
                    String path = parts[1];
                    String source = parts[0];
                    builder.addVolume(path, source);
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Invalid volume: " + spec);
        }
        String expires = options.getString(this.expiresArg.getDest());
        if (expires != null) {
            builder.setExpires(new DateTime((Object)expires).toDate());
        }
        String execHealthCheck = options.getString(this.healthCheckExecArg.getDest());
        String httpHealthCheck = options.getString(this.healthCheckHttpArg.getDest());
        String tcpHealthCheck = options.getString(this.healthCheckTcpArg.getDest());
        int numberOfHealthChecks = 0;
        for (String c : Arrays.asList(execHealthCheck, httpHealthCheck, tcpHealthCheck)) {
            if (Strings.isNullOrEmpty((String)c)) continue;
            ++numberOfHealthChecks;
        }
        if (numberOfHealthChecks > 1) {
            throw new IllegalArgumentException("Only one health check may be specified.");
        }
        if (!Strings.isNullOrEmpty((String)execHealthCheck)) {
            builder.setHealthCheck((HealthCheck)ExecHealthCheck.of((String)execHealthCheck));
        } else if (!Strings.isNullOrEmpty((String)httpHealthCheck)) {
            String[] parts = httpHealthCheck.split(":", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid HTTP health check: " + httpHealthCheck);
            }
            builder.setHealthCheck((HealthCheck)HttpHealthCheck.of((String)parts[0], (String)parts[1]));
        } else if (!Strings.isNullOrEmpty((String)tcpHealthCheck)) {
            builder.setHealthCheck((HealthCheck)TcpHealthCheck.of((String)tcpHealthCheck));
        }
        builder.setToken(options.getString(this.tokenArg.getDest()));
        Job job = builder.build();
        Set errors = JOB_VALIDATOR.validate(job);
        if (!errors.isEmpty()) {
            if (!json) {
                for (String error : errors) {
                    out.println(error);
                }
            } else {
                CreateJobResponse createJobResponse = new CreateJobResponse(CreateJobResponse.Status.INVALID_JOB_DEFINITION, null, job.getId().toString());
                out.println(createJobResponse.toJsonString());
            }
            return 1;
        }
        if (!quiet && !json) {
            out.println("Creating job: " + job.toJsonString());
        }
        if ((status = (CreateJobResponse)client.createJob(job).get()).getStatus() == CreateJobResponse.Status.OK) {
            if (!quiet && !json) {
                out.println("Done.");
            }
            if (json) {
                out.println(status.toJsonString());
            } else {
                out.println(job.getId());
            }
            return 0;
        }
        if (!quiet && !json) {
            out.println("Failed: " + status);
        } else if (json) {
            out.println(status.toJsonString());
        }
        return 1;
    }

    private Integer nullOrInteger(String s) {
        return s == null ? null : Integer.valueOf(s);
    }
}

