/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.cli.JobStatusTable;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.cli.command.JobStatusFetcher;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.TaskStatus;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobStatusCommand
extends ControlCommand {
    private final Argument jobArg;
    private final Argument hostArg;
    private final Argument fullArg;

    public JobStatusCommand(Subparser parser) {
        super(parser);
        parser.help("show job or host status");
        this.jobArg = parser.addArgument(new String[]{"-j", "--job"}).help("Job filter");
        this.hostArg = parser.addArgument(new String[]{"--host"}).setDefault((Object)"").help("Host pattern");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full hostnames, job and container id's.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException {
        String jobIdString = options.getString(this.jobArg.getDest());
        String hostPattern = options.getString(this.hostArg.getDest());
        final boolean full = options.getBoolean(this.fullArg.getDest());
        Map jobs = Strings.isNullOrEmpty((String)jobIdString) ? (Map)client.jobs().get() : (Map)client.jobs(jobIdString).get();
        if (jobs == null) {
            out.printf("The specified Helios master either returned an error or job id matcher \"%s\" matched no jobs%n", jobIdString);
            return 1;
        }
        Set<JobId> jobIds = jobs.keySet();
        if (!Strings.isNullOrEmpty((String)jobIdString) && jobIds.isEmpty()) {
            out.printf("job id matcher \"%s\" matched no jobs%n", jobIdString);
            return 1;
        }
        Map<JobId, ListenableFuture<JobStatus>> futures = JobStatusFetcher.getJobsStatuses(client, jobIds);
        TreeMap statuses = Maps.newTreeMap();
        statuses.putAll(Utils.allAsMap(futures));
        if (json) {
            this.showJsonStatuses(out, hostPattern, jobIds, statuses);
            return 0;
        }
        final JobStatusTable table = Output.jobStatusTable(out, full);
        boolean noHostMatchedEver = this.showStatusesForHosts(hostPattern, jobIds, statuses, new HostStatusDisplayer(){

            @Override
            public void matchedStatus(JobStatus jobStatus, Iterable<String> matchingHosts, Map<String, TaskStatus> taskStatuses) {
                JobStatusCommand.this.displayTask(full, table, jobStatus.getJob().getId(), jobStatus, taskStatuses, matchingHosts);
            }
        });
        if (noHostMatchedEver) {
            String domainsSwitchString = "";
            List domains = (List)options.get("domains");
            List sites = (List)options.get("sites");
            if (domains.size() > 0) {
                domainsSwitchString = "-d " + Joiner.on((String)",").join((Iterable)domains);
            } else if (sites.size() > 0) {
                domainsSwitchString = "-d " + Joiner.on((String)",").join((Iterable)sites);
            }
            out.printf("There are no jobs deployed to hosts with the pattern '%s'%nRun 'helios %s hosts %s' to check it exists and is up.%n", hostPattern, domainsSwitchString, hostPattern);
            return 1;
        }
        table.print();
        return 0;
    }

    private void showJsonStatuses(PrintStream out, String hostPattern, Set<JobId> jobIds, Map<JobId, JobStatus> statuses) {
        if (Strings.isNullOrEmpty((String)hostPattern)) {
            out.println(Json.asPrettyStringUnchecked(statuses));
            return;
        }
        final TreeMap returnStatuses = Maps.newTreeMap();
        this.showStatusesForHosts(hostPattern, jobIds, statuses, new HostStatusDisplayer(){

            @Override
            public void matchedStatus(JobStatus jobStatus, Iterable<String> matchingHosts, Map<String, TaskStatus> taskStatuses) {
                for (String host : matchingHosts) {
                    Map deployments = jobStatus.getDeployments();
                    Deployment deployment = deployments == null ? null : (Deployment)deployments.get(host);
                    if (deployment == null) continue;
                    returnStatuses.put(jobStatus.getJob().getId(), JobStatusCommand.this.filterJobStatus(jobStatus, matchingHosts));
                }
            }
        });
        out.println(Json.asPrettyStringUnchecked((Object)returnStatuses));
    }

    private JobStatus filterJobStatus(JobStatus jobStatus, Iterable<String> matchingHosts) {
        HashMap taskStatuses = Maps.newHashMap((Map)jobStatus.getTaskStatuses());
        HashSet matchingHostSet = Sets.newHashSet(matchingHosts);
        for (String key : Sets.newHashSet(taskStatuses.keySet())) {
            if (matchingHostSet.contains(key)) continue;
            taskStatuses.remove(key);
        }
        HashMap deployments = Maps.newHashMap((Map)jobStatus.getDeployments());
        for (String key : Sets.newHashSet(deployments.keySet())) {
            if (matchingHostSet.contains(key)) continue;
            deployments.remove(key);
        }
        return JobStatus.newBuilder().setJob(jobStatus.getJob()).setDeployments((Map)deployments).setTaskStatuses((Map)taskStatuses).build();
    }

    private boolean showStatusesForHosts(String hostPattern, Set<JobId> jobIds, Map<JobId, JobStatus> statuses, HostStatusDisplayer statusDisplayer) {
        boolean noHostMatchedEver = true;
        for (JobId jobId : Ordering.natural().sortedCopy(jobIds)) {
            JobStatus jobStatus = statuses.get(jobId);
            if (jobStatus == null) continue;
            TreeMap taskStatuses = Maps.newTreeMap();
            taskStatuses.putAll(jobStatus.getTaskStatuses());
            for (String host : jobStatus.getDeployments().keySet()) {
                if (taskStatuses.containsKey(host)) continue;
                taskStatuses.put(host, null);
            }
            FluentIterable matchingHosts = FluentIterable.from(taskStatuses.keySet()).filter(Predicates.containsPattern((String)hostPattern));
            if (Strings.isNullOrEmpty((String)hostPattern) || !Strings.isNullOrEmpty((String)hostPattern) && !matchingHosts.isEmpty()) {
                noHostMatchedEver = false;
            }
            statusDisplayer.matchedStatus(jobStatus, (Iterable<String>)matchingHosts, taskStatuses);
        }
        return noHostMatchedEver;
    }

    private void displayTask(boolean full, JobStatusTable table, JobId jobId, JobStatus jobStatus, Map<String, TaskStatus> taskStatuses, Iterable<String> matchingHosts) {
        for (String host : matchingHosts) {
            Map deployments = jobStatus.getDeployments();
            TaskStatus ts = taskStatuses.get(host);
            Deployment deployment = deployments == null ? null : (Deployment)deployments.get(host);
            table.task(jobId, Output.formatHostname(full, host), ts, deployment);
        }
    }

    static interface HostStatusDisplayer {
        public void matchedStatus(JobStatus var1, Iterable<String> var2, Map<String, TaskStatus> var3);
    }
}

