/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.spotify.helios.cli.command.WildcardJobCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.SetGoalResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobStopCommand
extends WildcardJobCommand {
    private final Argument hostsArg;
    private final Argument tokenArg;

    public JobStopCommand(Subparser parser) {
        super(parser);
        parser.help("stop a running job without undeploying it");
        this.hostsArg = parser.addArgument(new String[]{"hosts"}).nargs("+").help("The hosts to stop the job on.");
        this.tokenArg = parser.addArgument(new String[]{"--token"}).nargs("?").setDefault((Object)"").help("Insecure access token");
    }

    @Override
    protected int runWithJobId(Namespace options, HeliosClient client, PrintStream out, boolean json, JobId jobId, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        List hosts = options.getList(this.hostsArg.getDest());
        Deployment deployment = new Deployment.Builder().setGoal(Goal.STOP).setJobId(jobId).build();
        if (!json) {
            out.printf("Stopping %s on %s%n", jobId, hosts);
        }
        int code = 0;
        for (String host : hosts) {
            String token;
            SetGoalResponse result;
            if (!json) {
                out.printf("%s: ", host);
            }
            if ((result = (SetGoalResponse)client.setGoal(deployment, host, token = options.getString(this.tokenArg.getDest())).get()).getStatus() == SetGoalResponse.Status.OK) {
                if (json) {
                    out.printf(result.toJsonString(), new Object[0]);
                    continue;
                }
                out.printf("done%n", new Object[0]);
                continue;
            }
            if (json) {
                out.printf(result.toJsonString(), new Object[0]);
            } else {
                out.printf("failed: %s%n", result);
            }
            code = 1;
        }
        return code;
    }
}

