/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.cli.Target;
import com.spotify.helios.client.Endpoints;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostSelector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;

public class Utils {
    public static <K, V> Map<K, V> allAsMap(Map<K, ListenableFuture<V>> map) throws ExecutionException, InterruptedException {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<K, ListenableFuture<V>> e : map.entrySet()) {
            result.put(e.getKey(), e.getValue().get());
        }
        return result;
    }

    public static HeliosClient getClient(Target target, PrintStream err, String username) {
        List endpoints = Collections.emptyList();
        try {
            endpoints = (List)target.getEndpointSupplier().get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (endpoints.size() == 0) {
            err.println("Failed to resolve helios master in " + target);
            return null;
        }
        return HeliosClient.newBuilder().setEndpointSupplier(Endpoints.of(target.getEndpointSupplier())).setUser(username).build();
    }

    public static boolean userConfirmed(PrintStream out, BufferedReader stdin) throws IOException {
        out.printf("Do you want to continue? [y/N]%n", new Object[0]);
        String line = stdin.readLine().trim();
        if (line.length() < 1) {
            return false;
        }
        char c = line.charAt(0);
        return c == 'Y' || c == 'y';
    }

    public static Map<String, String> argToStringMap(Namespace namespace, Argument arg) {
        List args = namespace.getList(arg.getDest());
        HashMap map = Maps.newHashMap();
        if (args != null) {
            for (List group : args) {
                for (String s : group) {
                    String[] parts = s.split("=", 2);
                    if (parts.length != 2) {
                        throw new IllegalArgumentException("Bad " + arg.textualName() + " value: " + s);
                    }
                    map.put(parts[0], parts[1]);
                }
            }
        }
        return map;
    }

    public static <K extends Comparable<K>, V> void printMap(PrintStream out, String name, Function<V, String> transform, Map<K, V> values) {
        out.print(name);
        boolean first = true;
        for (Comparable key : Ordering.natural().sortedCopy(values.keySet())) {
            if (!first) {
                out.print(Strings.repeat((String)" ", (int)name.length()));
            }
            V value = values.get(key);
            out.printf("%s=%s%n", key, transform.apply(value));
            first = false;
        }
        if (first) {
            out.println();
        }
    }

    public static List<HostSelector> parseHostSelectors(Namespace namespace, Argument arg) {
        List args = namespace.getList(arg.getDest());
        ArrayList ret = Lists.newArrayList();
        if (args != null) {
            for (List group : args) {
                for (String s : group) {
                    HostSelector hostSelector = HostSelector.parse((String)s);
                    if (hostSelector == null) {
                        throw new IllegalArgumentException(String.format("Bad host selector expression: '%s'", s));
                    }
                    ret.add(hostSelector);
                }
            }
        }
        return ret;
    }
}

