/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.protocol.RemoveDeploymentGroupResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DeploymentGroupRemoveCommand
extends ControlCommand {
    private final Argument nameArg;

    public DeploymentGroupRemoveCommand(Subparser parser) {
        super(parser);
        parser.help("remove a deployment-group. Note that this does not undeploy jobs previously deployed by the deployment-group");
        this.nameArg = parser.addArgument(new String[]{"deployment-group-name"}).required(true).help("Deployment group name");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        boolean failed;
        String name = options.getString(this.nameArg.getDest());
        RemoveDeploymentGroupResponse status = (RemoveDeploymentGroupResponse)client.removeDeploymentGroup(name).get();
        if (status == null) {
            throw new RuntimeException("The Helios master could not remove the given deployment group.");
        }
        boolean bl = failed = status.getStatus() != RemoveDeploymentGroupResponse.Status.REMOVED;
        if (json) {
            out.println(status.toJsonString());
        } else if (failed) {
            out.println(String.format("Failed to remove deployment-group %s, status: %s", name, status.getStatus()));
        } else {
            out.println(String.format("Deployment-group %s removed", name));
        }
        return failed ? 1 : 0;
    }
}

