/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Strings;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.cli.command.DeploymentGroupStatusCommand;
import com.spotify.helios.client.HeliosClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DeploymentGroupWatchCommand
extends ControlCommand {
    private static final int MAX_WIDTH = 80;
    private static final String DATE_TIME_PATTERN = "YYYY-MM-dd HH:mm:ss";
    private final Argument nameArg;
    private final Argument fullArg;
    private final Argument intervalArg;

    public DeploymentGroupWatchCommand(Subparser parser) {
        super(parser);
        parser.help("watch deployment groups");
        this.nameArg = parser.addArgument(new String[]{"name"}).help("Deployment group name");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full hostnames and job ids.");
        this.intervalArg = parser.addArgument(new String[]{"--interval"}).type(Integer.class).setDefault((Object)1).help("polling interval, default 1 second");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        String name = options.getString(this.nameArg.getDest());
        boolean full = options.getBoolean(this.fullArg.getDest());
        Integer interval = options.getInt(this.intervalArg.getDest());
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)DATE_TIME_PATTERN);
        if (!json) {
            out.println("Control-C to stop");
            out.println("STATUS               HOST                           STATE");
        }
        int timestampLength = String.format("[%s UTC]", DATE_TIME_PATTERN).length();
        int rc = 0;
        while (rc == 0) {
            Instant now = new Instant();
            if (!json) {
                out.printf(Strings.repeat((String)"-", (int)(80 - timestampLength - 1)) + " [%s UTC]%n", now.toString(formatter));
            }
            rc = DeploymentGroupStatusCommand.run0(client, out, json, name, full);
            if (out.checkError()) break;
            Thread.sleep(1000 * interval);
        }
        return 0;
    }
}

