/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.collect.ImmutableList;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.HostResolver;
import com.spotify.helios.cli.command.WildcardJobCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobUndeployCommand
extends WildcardJobCommand {
    private static final Logger log = LoggerFactory.getLogger(JobUndeployCommand.class);
    private final Argument hostsArg;
    private final Argument tokenArg;
    private final Argument allArg;
    private final Argument yesArg;
    private final Argument forceArg;

    public JobUndeployCommand(Subparser parser) {
        super(parser);
        parser.help("undeploy a job from hosts");
        this.hostsArg = parser.addArgument(new String[]{"hosts"}).nargs("*").help("The hosts to undeploy the job from.");
        this.tokenArg = parser.addArgument(new String[]{"--token"}).nargs("?").setDefault((Object)"").help("Insecure access token");
        this.allArg = parser.addArgument(new String[]{"-a", "--all"}).action((ArgumentAction)Arguments.storeTrue()).help("Undeploy from all currently deployed hosts.");
        this.yesArg = parser.addArgument(new String[]{"--yes"}).action((ArgumentAction)Arguments.storeTrue()).help("Automatically answer 'yes' to the interactive prompt.");
        this.forceArg = parser.addArgument(new String[]{"--force"}).action((ArgumentAction)Arguments.storeTrue()).help("Automatically answer 'yes' to the interactive prompt.");
    }

    @Override
    protected int runWithJobId(Namespace options, HeliosClient client, PrintStream out, boolean json, JobId jobId, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        List hosts;
        boolean all = options.getBoolean(this.allArg.getDest());
        boolean yes = options.getBoolean(this.yesArg.getDest());
        boolean force = options.getBoolean(this.forceArg.getDest());
        if (force) {
            log.warn("If you are using '--force' to skip the interactive prompt, note that we have deprecated it. Please use '--yes'.");
        }
        if (all) {
            JobStatus status = (JobStatus)client.jobStatus(jobId).get();
            hosts = ImmutableList.copyOf(status.getDeployments().keySet());
            if (hosts.isEmpty()) {
                out.printf("%s is not currently deployed on any hosts.", jobId);
                return 0;
            }
            if (!yes && !force) {
                out.printf("This will undeploy %s from %s%n", jobId, hosts);
                boolean confirmed = Utils.userConfirmed(out, stdin);
                if (!confirmed) {
                    return 1;
                }
            }
        } else {
            hosts = options.getList(this.hostsArg.getDest());
            if (hosts.isEmpty()) {
                out.println("Please either specify a list of hosts or use the -a/--all flag.");
                return 1;
            }
        }
        if (!json) {
            out.printf("Undeploying %s from %s%n", jobId, hosts);
        }
        int code = 0;
        HostResolver resolver = HostResolver.create(client);
        for (String candidateHost : hosts) {
            String token;
            JobUndeployResponse response;
            String host = resolver.resolveName(candidateHost);
            if (!json) {
                out.printf("%s: ", host);
            }
            if ((response = (JobUndeployResponse)client.undeploy(jobId, host, token = options.getString(this.tokenArg.getDest())).get()).getStatus() == JobUndeployResponse.Status.OK) {
                if (!json) {
                    out.println("done");
                    continue;
                }
                out.print(response.toJsonString());
                continue;
            }
            if (!json) {
                out.println("failed: " + response);
            } else {
                out.print(response.toJsonString());
            }
            code = -1;
        }
        return code;
    }
}

