/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.PrintStream;
import java.util.List;

public class Table {
    private final PrintStream out;
    private final String paddingString;
    private int[] columns = new int[0];
    private final List<Object[]> rows = Lists.newArrayList();

    public Table(PrintStream out, int padding) {
        this.out = out;
        this.paddingString = Strings.repeat((String)" ", (int)padding);
    }

    public Table(PrintStream out) {
        this(out, 4);
    }

    public void row(Object ... row) {
        this.columns = Ints.ensureCapacity((int[])this.columns, (int)row.length, (int)row.length);
        for (int i = 0; i < row.length; ++i) {
            row[i] = row[i].toString();
            this.columns[i] = Math.max(this.columns[i], row[i].toString().length());
        }
        this.rows.add(row);
    }

    public void print() {
        for (Object[] row : this.rows) {
            for (int i = 0; i < row.length; ++i) {
                String cell = row[i].toString();
                this.out.print(cell);
                this.out.print(this.paddingString);
                int padding = this.columns[i] - cell.length();
                for (int j = 0; j < padding; ++j) {
                    this.out.print(' ');
                }
            }
            this.out.println();
        }
    }
}

