/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.spotify.helios.cli.Target;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.CliCommand;
import com.spotify.helios.client.HeliosClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public abstract class ControlCommand
implements CliCommand {
    private final boolean shortCircuit;

    ControlCommand(Subparser parser) {
        this(parser, false);
    }

    ControlCommand(Subparser parser, boolean shortCircuit) {
        parser.setDefault("command", (Object)this).defaultHelp(true);
        this.shortCircuit = shortCircuit;
    }

    @Override
    public int run(Namespace options, List<Target> targets, PrintStream out, PrintStream err, String username, boolean json, BufferedReader stdin) throws Exception {
        boolean allSuccessful = true;
        boolean isFirst = true;
        Iterator<Target> targetIterator = targets.iterator();
        while (targetIterator.hasNext()) {
            Target target = targetIterator.next();
            if (targets.size() > 1) {
                if (!json) {
                    List endpoints = (List)target.getEndpointSupplier().get();
                    String header = String.format("%s (%s)", target.getName(), endpoints);
                    out.println(header);
                    out.println(Strings.repeat((String)"-", (int)header.length()));
                    out.flush();
                } else {
                    if (isFirst) {
                        out.println("{");
                        isFirst = false;
                    }
                    out.println("\"" + target.getName() + "\": ");
                }
            }
            boolean successful = this.run(options, target, out, err, username, json, stdin);
            if (this.shortCircuit && !successful) {
                return 1;
            }
            allSuccessful &= successful;
            if (targets.size() <= 1) continue;
            if (!json) {
                out.println();
                continue;
            }
            if (targetIterator.hasNext()) {
                out.println(",\n");
                continue;
            }
            out.println("}");
        }
        return allSuccessful ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run(Namespace options, Target target, PrintStream out, PrintStream err, String username, boolean json, BufferedReader stdin) throws Exception {
        HeliosClient client = Utils.getClient(target, err, username, options);
        if (client == null) {
            return false;
        }
        try {
            int result = this.run(options, client, out, json, stdin);
            boolean bl = result == 0;
            return bl;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof TimeoutException)) {
                throw Throwables.propagate((Throwable)cause);
            }
            err.println("Request timed out to master in " + target);
            boolean bl = false;
            return bl;
        }
        finally {
            client.close();
        }
    }

    abstract int run(Namespace var1, HeliosClient var2, PrintStream var3, boolean var4, BufferedReader var5) throws ExecutionException, InterruptedException, IOException;
}

