/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Strings;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class HostRegisterCommand
extends ControlCommand {
    private final Argument hostArg;
    private final Argument idArg;

    public HostRegisterCommand(Subparser parser) {
        super(parser);
        parser.help("register a host");
        this.hostArg = parser.addArgument(new String[]{"host"}).help("The hostname of the agent you want to register with the Helios masters.");
        this.idArg = parser.addArgument(new String[]{"id"}).help("A unique ID for this host.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException {
        String host = options.getString(this.hostArg.getDest());
        String id = options.getString(this.idArg.getDest());
        if (Strings.isNullOrEmpty((String)host) || Strings.isNullOrEmpty((String)id)) {
            out.print("You must specify the hostname and id.");
            return 1;
        }
        out.printf("Registering host %s with id %s%n", host, id);
        int code = 0;
        out.printf("%s: ", host);
        int result = (Integer)client.registerHost(host, id).get();
        if (result == 200) {
            out.printf("done%n", new Object[0]);
        } else {
            out.printf("failed: %s%n", result);
            code = 1;
        }
        return code;
    }
}

