/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.spotify.helios.client.HeliosClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.xbill.DNS.Name;
import org.xbill.DNS.ResolverConfig;

class HostResolver {
    private static final Name[] EMPTY_PATH = new Name[0];
    private final Set<String> allHosts;
    private final Name[] searchPath;

    HostResolver(Set<String> allHosts, Name[] searchPath) throws InterruptedException, ExecutionException {
        this.allHosts = allHosts;
        this.searchPath = searchPath;
    }

    static HostResolver create(HeliosClient client) throws InterruptedException, ExecutionException {
        Name[] possiblePath;
        ResolverConfig currentConfig = ResolverConfig.getCurrentConfig();
        Name[] path = currentConfig != null ? ((possiblePath = currentConfig.searchPath()) != null ? possiblePath : EMPTY_PATH) : EMPTY_PATH;
        return new HostResolver(Sets.newHashSet((Iterable)((Iterable)client.listHosts().get())), path);
    }

    String resolveName(String host) {
        if (this.allHosts.contains(host)) {
            return host;
        }
        List<String> matches = this.findPrefixMatches(host);
        if (matches.isEmpty()) {
            return host;
        }
        if (matches.size() == 1) {
            return matches.iterator().next();
        }
        List<ScoredHost> scored = this.scoreMatches(matches);
        List<ScoredHost> sorted = this.sortScoredHosts(scored);
        List<String> minScoreHosts = this.findMatchesWithLowestScore(sorted);
        if (minScoreHosts.size() > 1) {
            return host;
        }
        return minScoreHosts.get(0);
    }

    public List<String> getSortedMatches(String hostName) {
        List<String> matches = this.findPrefixMatches(hostName);
        List<ScoredHost> scored = this.scoreMatches(matches);
        List<ScoredHost> sorted = this.sortScoredHosts(scored);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ScoredHost host : sorted) {
            builder.add((Object)host.host);
        }
        return builder.build();
    }

    private List<ScoredHost> sortScoredHosts(List<ScoredHost> scored) {
        ArrayList copy = Lists.newArrayList(scored);
        Collections.sort(copy, new Comparator<ScoredHost>(){

            @Override
            public int compare(ScoredHost o1, ScoredHost o2) {
                return o1.score - o2.score;
            }
        });
        return copy;
    }

    private List<String> findPrefixMatches(String pfx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String name : this.allHosts) {
            if (!name.startsWith(pfx)) continue;
            builder.add((Object)name);
        }
        return builder.build();
    }

    private List<String> findMatchesWithLowestScore(List<ScoredHost> scored) {
        int minScore = scored.get(0).score;
        ImmutableList.Builder minScoreHosts = ImmutableList.builder();
        for (ScoredHost score : scored) {
            if (score.score != minScore) continue;
            minScoreHosts.add((Object)score.host);
        }
        return minScoreHosts.build();
    }

    private List<ScoredHost> scoreMatches(List<String> results) {
        ImmutableList.Builder scored = ImmutableList.builder();
        for (String name : results) {
            int score = Integer.MAX_VALUE;
            for (int i = 0; i < this.searchPath.length; ++i) {
                if (!name.endsWith(this.searchPath[i].toString()) || i >= score) continue;
                score = i;
            }
            scored.add((Object)new ScoredHost(name, score));
        }
        return scored.build();
    }

    private static class ScoredHost {
        private final String host;
        private final int score;

        public ScoredHost(String host, int score) {
            this.host = host;
            this.score = score;
        }
    }
}

