/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.spotify.helios.cli.command.HostResolver;
import com.spotify.helios.cli.command.JobWatchCommand;
import com.spotify.helios.cli.command.WildcardJobCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.JobDeployResponse;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobDeployCommand
extends WildcardJobCommand {
    private final Argument hostsArg;
    private final Argument tokenArg;
    private final Argument noStartArg;
    private final Argument watchArg;
    private final Argument intervalArg;

    public JobDeployCommand(Subparser parser) {
        super(parser);
        parser.help("deploy a job to hosts");
        this.hostsArg = parser.addArgument(new String[]{"hosts"}).nargs("+").help("The hosts to deploy the job on.");
        this.tokenArg = parser.addArgument(new String[]{"--token"}).nargs("?").setDefault((Object)"").help("Insecure access token");
        this.noStartArg = parser.addArgument(new String[]{"--no-start"}).action((ArgumentAction)Arguments.storeTrue()).help("Deploy job without starting it.");
        this.watchArg = parser.addArgument(new String[]{"--watch"}).action((ArgumentAction)Arguments.storeTrue()).help("Watch the newly deployed job (like running job watch right after)");
        this.intervalArg = parser.addArgument(new String[]{"--interval"}).setDefault((Object)1).help("if --watch is specified, the polling interval, default 1 second");
    }

    @Override
    protected int runWithJobId(Namespace options, HeliosClient client, PrintStream out, boolean json, JobId jobId, BufferedReader stdin) throws ExecutionException, InterruptedException {
        List hosts = options.getList(this.hostsArg.getDest());
        Deployment job = Deployment.of((JobId)jobId, (Goal)(options.getBoolean(this.noStartArg.getDest()) != false ? Goal.STOP : Goal.START));
        if (!json) {
            out.printf("Deploying %s on %s%n", job, hosts);
        }
        int code = 0;
        HostResolver resolver = HostResolver.create(client);
        ArrayList resolvedHosts = Lists.newArrayList();
        for (String candidateHost : hosts) {
            String token;
            JobDeployResponse result;
            String host = resolver.resolveName(candidateHost);
            resolvedHosts.add(host);
            if (!json) {
                out.printf("%s: ", host);
            }
            if ((result = (JobDeployResponse)client.deploy(job, host, token = options.getString(this.tokenArg.getDest())).get()).getStatus() == JobDeployResponse.Status.OK) {
                if (!json) {
                    out.printf("done%n", new Object[0]);
                    continue;
                }
                out.print(result.toJsonString());
                continue;
            }
            if (!json) {
                out.printf("failed: %s%n", result);
            } else {
                out.print(result.toJsonString());
            }
            code = 1;
        }
        if (code == 0 && options.getBoolean(this.watchArg.getDest()).booleanValue()) {
            JobWatchCommand.watchJobsOnHosts(out, true, (List<String>)resolvedHosts, (List<JobId>)ImmutableList.of((Object)jobId), options.getInt(this.intervalArg.getDest()), client);
        }
        return code;
    }
}

