/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Table;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.cli.command.JobStatusFetcher;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobListCommand
extends ControlCommand {
    private final Argument quietArg;
    private final Argument patternArg;
    private final Argument fullArg;
    private final Argument deployedArg;

    public JobListCommand(Subparser parser) {
        super(parser);
        parser.help("list jobs");
        this.patternArg = parser.addArgument(new String[]{"pattern"}).nargs("?").help("Job reference to filter on");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full job id's.");
        this.quietArg = parser.addArgument(new String[]{"-q"}).action((ArgumentAction)Arguments.storeTrue()).help("only print job id's");
        this.deployedArg = parser.addArgument(new String[]{"-y"}).action((ArgumentAction)Arguments.storeTrue()).help("only show deployed jobs");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException {
        boolean full = options.getBoolean(this.fullArg.getDest());
        boolean quiet = options.getBoolean(this.quietArg.getDest());
        String pattern = options.getString(this.patternArg.getDest());
        boolean deployed = options.getBoolean(this.deployedArg.getDest());
        Map jobs = pattern == null ? (Map)client.jobs().get() : (Map)client.jobs(pattern).get();
        if (!Strings.isNullOrEmpty((String)pattern) && jobs.isEmpty()) {
            if (json) {
                out.println(Json.asPrettyStringUnchecked((Object)jobs));
            } else if (!quiet) {
                out.printf("job pattern %s matched no jobs%n", pattern);
            }
            return 1;
        }
        Map<JobId, ListenableFuture<JobStatus>> oldFutures = JobStatusFetcher.getJobsStatuses(client, jobs.keySet());
        HashMap futures = Maps.newHashMap();
        if (!deployed) {
            futures.putAll(oldFutures);
        } else {
            for (Map.Entry<JobId, ListenableFuture<JobStatus>> e : oldFutures.entrySet()) {
                if (((JobStatus)e.getValue().get()).getDeployments().isEmpty()) continue;
                futures.put(e.getKey(), e.getValue());
            }
        }
        TreeSet sortedJobIds = Sets.newTreeSet(futures.keySet());
        if (json) {
            if (quiet) {
                out.println(Json.asPrettyStringUnchecked((Object)sortedJobIds));
            } else {
                HashMap filteredJobs = Maps.newHashMap();
                for (Map.Entry entry : jobs.entrySet()) {
                    if (!futures.containsKey(entry.getKey())) continue;
                    filteredJobs.put(entry.getKey(), entry.getValue());
                }
                out.println(Json.asPrettyStringUnchecked((Object)filteredJobs));
            }
        } else if (quiet) {
            for (JobId jobId : sortedJobIds) {
                out.println(jobId);
            }
        } else {
            Table table = Output.table(out);
            table.row("JOB ID", "NAME", "VERSION", "HOSTS", "COMMAND", "ENVIRONMENT");
            for (JobId jobId : sortedJobIds) {
                Job job = (Job)jobs.get(jobId);
                String command = Joiner.on((char)' ').join(JobListCommand.escape(job.getCommand()));
                String env = Joiner.on((String)" ").withKeyValueSeparator("=").join(job.getEnv());
                JobStatus status = (JobStatus)((ListenableFuture)futures.get(jobId)).get();
                table.row(full ? jobId : jobId.toShortString(), jobId.getName(), jobId.getVersion(), status != null ? status.getDeployments().keySet().size() : 0, command, env);
            }
            table.print();
        }
        return 0;
    }

    private static List<String> escape(List<String> command) {
        ArrayList escaped = Lists.newArrayList();
        for (String s : command) {
            escaped.add(JobListCommand.escape(s));
        }
        return escaped;
    }

    private static String escape(String arg) {
        return CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)arg) ? '\"' + arg + '\"' : arg;
    }
}

