/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.spotify.helios.common.Json;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CliConfig {
    private static final String HTTP_SCHEME = "http";
    private static final String DOMAIN_SCHEME = "domain";
    private static final String DEPRECATED_SITE_SCHEME = "site";
    private static final String MASTER_ENDPOINTS_KEY = "masterEndpoints";
    private static final String DOMAINS_KEY = "domains";
    private static final String SRV_NAME_KEY = "srvName";
    private static final String CONFIG_DIR = ".helios";
    private static final String CONFIG_FILE = "config";
    private static final String CONFIG_PATH = ".helios" + File.separator + "config";
    public static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    public static final TypeReference<Map<String, Object>> OBJECT_TYPE = new TypeReference<Map<String, Object>>(){};
    static Map<String, String> environment = System.getenv();
    private final String username = System.getProperty("user.name");
    private final List<String> domains;
    private final String srvName;
    private final List<URI> masterEndpoints;

    public CliConfig(List<String> domains, String srvName, List<URI> masterEndpoints) {
        this.domains = (List)Preconditions.checkNotNull(domains);
        this.srvName = (String)Preconditions.checkNotNull((Object)srvName);
        this.masterEndpoints = (List)Preconditions.checkNotNull(masterEndpoints);
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public String getDomainsString() {
        return Joiner.on((String)",").join(this.domains);
    }

    public String getSrvName() {
        return this.srvName;
    }

    public List<URI> getMasterEndpoints() {
        return this.masterEndpoints;
    }

    public static String getConfigDirName() {
        return CONFIG_DIR;
    }

    public static String getConfigFileName() {
        return CONFIG_FILE;
    }

    public static CliConfig fromUserConfig() throws IOException, URISyntaxException {
        String userHome = System.getProperty("user.home");
        String defaults = userHome + File.separator + CONFIG_PATH;
        File defaultsFile = new File(defaults);
        return CliConfig.fromFile(defaultsFile);
    }

    public static CliConfig fromFile(File defaultsFile) throws IOException, URISyntaxException {
        Object config = defaultsFile.exists() && defaultsFile.canRead() ? (Map)Json.read((byte[])Files.readAllBytes(defaultsFile.toPath()), OBJECT_TYPE) : ImmutableMap.of();
        return CliConfig.fromEnvVar((Map<String, Object>)config);
    }

    public static CliConfig fromEnvVar(Map<String, Object> config) throws URISyntaxException {
        String scheme;
        String master = environment.get("HELIOS_MASTER");
        if (master == null) {
            return CliConfig.fromMap(config);
        }
        URI uri = new URI(master);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (config.containsKey(SRV_NAME_KEY)) {
            builder.put((Object)SRV_NAME_KEY, config.get(SRV_NAME_KEY));
        }
        switch (scheme = uri.getScheme()) {
            case "domain": 
            case "site": {
                builder.put((Object)DOMAINS_KEY, (Object)ImmutableList.of((Object)uri.getHost())).build();
                break;
            }
            case "http": {
                builder.put((Object)MASTER_ENDPOINTS_KEY, (Object)ImmutableList.of((Object)master));
                break;
            }
            default: {
                throw new RuntimeException("Unknown Scheme " + scheme + " in HELIOS_MASTER env variable setting of [" + master + "]");
            }
        }
        return CliConfig.fromMap((Map<String, Object>)builder.build());
    }

    public static CliConfig fromMap(Map<String, Object> config) {
        Preconditions.checkNotNull(config);
        List<String> domains = CliConfig.getList(config, DOMAINS_KEY, EMPTY_STRING_LIST);
        String srvName = CliConfig.getString(config, SRV_NAME_KEY, "helios");
        ArrayList masterEndpoints = Lists.newArrayList();
        for (String endpoint : CliConfig.getList(config, MASTER_ENDPOINTS_KEY, EMPTY_STRING_LIST)) {
            masterEndpoints.add(URI.create(endpoint));
        }
        return new CliConfig(domains, srvName, masterEndpoints);
    }

    private static String getString(Map<String, Object> config, String key, String defaultValue) {
        return (String)Optional.fromNullable((Object)((String)config.get(key))).or((Object)defaultValue);
    }

    private static <T> List<T> getList(Map<String, Object> config, String key, List<T> defaultValue) {
        List value = (List)config.get(key);
        return (List)Optional.fromNullable((Object)value).or(defaultValue);
    }
}

