/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Joiner;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.cli.command.HostResolver;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.protocol.HostDeregisterResponse;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class HostDeregisterCommand
extends ControlCommand {
    private final Argument hostArg;
    private final Argument forceArg;

    public HostDeregisterCommand(Subparser parser) {
        super(parser);
        parser.help("deregister a host");
        this.hostArg = parser.addArgument(new String[]{"host"}).help("Host name to deregister.");
        this.forceArg = parser.addArgument(new String[]{"--force"}).action((ArgumentAction)Arguments.storeTrue()).help("Force deregistration.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json) throws ExecutionException, InterruptedException, IOException {
        String host = options.getString(this.hostArg.getDest());
        boolean force = options.getBoolean(this.forceArg.getDest());
        if (!force) {
            out.printf("This will deregister the host %s%n", host);
            out.printf("Do you want to continue? [y/N]%n", new Object[0]);
            int c = System.in.read();
            if (c != 89 && c != 121) {
                return 1;
            }
        }
        out.printf("Deregistering host %s%n", host);
        int code = 0;
        HostDeregisterResponse response = (HostDeregisterResponse)client.deregisterHost(host).get();
        out.printf("%s: ", host);
        if (response.getStatus() == HostDeregisterResponse.Status.OK) {
            out.printf("done%n", new Object[0]);
        } else {
            HostResolver resolver;
            List<String> resolved;
            out.printf("failed: %s%n", response);
            if (response.getStatus() == HostDeregisterResponse.Status.NOT_FOUND && !(resolved = (resolver = HostResolver.create(client)).getSortedMatches(host)).isEmpty()) {
                out.println("We didn't find your hostname, but we did find some possible matches for you:\n    " + Joiner.on((String)"\n    ").join(resolved) + "\n");
            }
            code = 1;
        }
        return code;
    }
}

