/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Table;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.DockerVersion;
import com.spotify.helios.common.descriptors.HostInfo;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class HostListCommand
extends ControlCommand {
    private final Argument quietArg;
    private final Argument patternArg;
    private final Argument fullArg;

    public HostListCommand(Subparser parser) {
        super(parser);
        parser.help("list hosts");
        this.patternArg = parser.addArgument(new String[]{"pattern"}).nargs("?").setDefault((Object)"").help("Pattern to filter hosts with");
        this.quietArg = parser.addArgument(new String[]{"-q"}).action((ArgumentAction)Arguments.storeTrue()).help("only print host names");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full host names.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json) throws ExecutionException, InterruptedException {
        String pattern = options.getString(this.patternArg.getDest());
        ImmutableList hosts = FluentIterable.from((Iterable)((Iterable)client.listHosts().get())).filter(Predicates.containsPattern((String)pattern)).toList();
        boolean full = options.getBoolean(this.fullArg.getDest());
        if (!Strings.isNullOrEmpty((String)pattern) && hosts.isEmpty()) {
            out.printf("host pattern %s matched no hosts%n", pattern);
            return 1;
        }
        List sortedHosts = Ordering.natural().sortedCopy((Iterable)hosts);
        boolean quiet = options.getBoolean(this.quietArg.getDest());
        if (quiet) {
            if (json) {
                out.println(Json.asPrettyStringUnchecked((Object)sortedHosts));
            } else {
                for (String host : sortedHosts) {
                    out.println(Output.formatHostname(full, host));
                }
            }
        } else {
            TreeMap statuses = Maps.newTreeMap();
            for (String host : hosts) {
                statuses.put(host, client.hostStatus(host));
            }
            if (json) {
                TreeMap sorted = Maps.newTreeMap();
                sorted.putAll(Utils.allAsMap(statuses));
                out.println(Json.asPrettyStringUnchecked((Object)sorted));
            } else {
                Table table = Output.table(out);
                table.row("HOST", "STATUS", "DEPLOYED", "RUNNING", "CPUS", "MEM", "LOAD AVG", "MEM USAGE", "OS", "HELIOS", "DOCKER");
                for (Map.Entry e : statuses.entrySet()) {
                    String status;
                    String docker;
                    String os;
                    String loadAvg;
                    String mem;
                    String cpus;
                    String memUsage;
                    String host = (String)e.getKey();
                    HostStatus s = (HostStatus)((ListenableFuture)e.getValue()).get();
                    if (s == null) continue;
                    HashSet runningDeployedJobs = Sets.newHashSet();
                    for (JobId jobId : s.getJobs().keySet()) {
                        TaskStatus taskStatus = (TaskStatus)s.getStatuses().get(jobId);
                        if (taskStatus == null || taskStatus.getState() != TaskStatus.State.RUNNING) continue;
                        runningDeployedJobs.add(taskStatus);
                    }
                    HostInfo hi = s.getHostInfo();
                    if (hi != null) {
                        long free = hi.getMemoryFreeBytes();
                        long total = hi.getMemoryTotalBytes();
                        memUsage = String.format("%.2f", Float.valueOf((float)(total - free) / (float)total));
                        cpus = String.valueOf(hi.getCpus());
                        mem = hi.getMemoryTotalBytes() / 0x40000000L + " gb";
                        loadAvg = String.format("%.2f", hi.getLoadAvg());
                        os = hi.getOsName() + " " + hi.getOsVersion();
                        DockerVersion dv = hi.getDockerVersion();
                        docker = dv != null ? String.format("%s (%s)", dv.getVersion(), dv.getApiVersion()) : "";
                    } else {
                        docker = "";
                        os = "";
                        loadAvg = "";
                        mem = "";
                        cpus = "";
                        memUsage = "";
                    }
                    String version = s.getAgentInfo() != null ? (String)Optional.fromNullable((Object)s.getAgentInfo().getVersion()).or((Object)"") : "";
                    String string = status = s.getStatus() == HostStatus.Status.UP ? "Up" : "Down";
                    if (s.getAgentInfo() != null) {
                        long startTime = s.getAgentInfo().getStartTime();
                        long upTime = s.getAgentInfo().getUptime();
                        status = s.getStatus() == HostStatus.Status.UP ? status + " " + Output.humanDuration(System.currentTimeMillis() - startTime) : status + " " + Output.humanDuration(System.currentTimeMillis() - startTime - upTime);
                    }
                    table.row(Output.formatHostname(full, host), status, s.getJobs().size(), runningDeployedJobs.size(), cpus, mem, loadAvg, memUsage, os, version, docker);
                }
                table.print();
            }
        }
        return 0;
    }
}

