/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.spotify.helios.cli.JobStatusTable;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.TaskStatus;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobStatusCommand
extends ControlCommand {
    private final Argument jobArg;
    private final Argument hostArg;
    private final Argument fullArg;

    public JobStatusCommand(Subparser parser) {
        super(parser);
        parser.help("show job or host status");
        this.jobArg = parser.addArgument(new String[]{"-j", "--job"}).help("Job filter");
        this.hostArg = parser.addArgument(new String[]{"--host"}).setDefault((Object)"").help("Host pattern");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full hostnames, job and container id's.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json) throws ExecutionException, InterruptedException {
        String jobIdString = options.getString(this.jobArg.getDest());
        String hostPattern = options.getString(this.hostArg.getDest());
        boolean full = options.getBoolean(this.fullArg.getDest());
        Set jobIds = Strings.isNullOrEmpty((String)jobIdString) ? ((Map)client.jobs().get()).keySet() : ((Map)client.jobs(jobIdString).get()).keySet();
        if (!Strings.isNullOrEmpty((String)jobIdString) && jobIds.isEmpty()) {
            out.printf("job id matcher %s matched no jobs%n", jobIdString);
            return 1;
        }
        TreeMap futures = Maps.newTreeMap();
        for (JobId jobId : jobIds) {
            futures.put(jobId, client.jobStatus(jobId));
        }
        TreeMap statuses = Maps.newTreeMap();
        statuses.putAll(Utils.allAsMap(futures));
        if (json) {
            out.println(Json.asPrettyStringUnchecked((Object)statuses));
            return 0;
        }
        JobStatusTable table = Output.jobStatusTable(out, full);
        boolean noHostMatchedEver = true;
        for (JobId jobId : Ordering.natural().sortedCopy(jobIds)) {
            JobStatus jobStatus = (JobStatus)statuses.get(jobId);
            TreeMap taskStatuses = Maps.newTreeMap();
            taskStatuses.putAll(jobStatus.getTaskStatuses());
            for (String host : jobStatus.getDeployments().keySet()) {
                if (taskStatuses.containsKey(host)) continue;
                taskStatuses.put(host, null);
            }
            FluentIterable matchingHosts = FluentIterable.from(taskStatuses.keySet()).filter(Predicates.containsPattern((String)hostPattern));
            if (Strings.isNullOrEmpty((String)hostPattern) || !Strings.isNullOrEmpty((String)hostPattern) && !matchingHosts.isEmpty()) {
                noHostMatchedEver = false;
            }
            for (String host : matchingHosts) {
                Map deployments = jobStatus.getDeployments();
                TaskStatus ts = (TaskStatus)taskStatuses.get(host);
                Deployment deployment = deployments == null ? null : (Deployment)deployments.get(host);
                table.task(jobId, Output.formatHostname(full, host), ts, deployment);
            }
        }
        if (noHostMatchedEver) {
            out.printf("host pattern %s matched no hosts%n", hostPattern);
            return 1;
        }
        table.print();
        return 0;
    }
}

