/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class MasterListCommand
extends ControlCommand {
    private final Argument fullArg;

    public MasterListCommand(Subparser parser) {
        super(parser);
        parser.help("list masters");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full hostnames");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json) throws ExecutionException, InterruptedException {
        List masters = (List)client.listMasters().get();
        boolean full = options.getBoolean(this.fullArg.getDest());
        for (String host : masters) {
            out.println(Output.formatHostname(full, host));
        }
        return 0;
    }
}

