/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.collect.Iterables;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.JobDeployResponse;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

abstract class WildcardJobCommand
extends ControlCommand {
    private final Argument jobArg;

    public WildcardJobCommand(Subparser parser) {
        super(parser);
        this.jobArg = parser.addArgument(new String[]{"job"}).help("Job id.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json) throws ExecutionException, InterruptedException, IOException {
        String jobIdString = options.getString(this.jobArg.getDest());
        Map jobs = (Map)client.jobs(jobIdString).get();
        if (jobs.size() == 0) {
            if (!json) {
                out.printf("Unknown job: %s%n", jobIdString);
            } else {
                JobDeployResponse jobDeployResponse = new JobDeployResponse(JobDeployResponse.Status.JOB_NOT_FOUND, null, null);
                out.printf(jobDeployResponse.toJsonString(), new Object[0]);
            }
            return 1;
        }
        if (jobs.size() > 1) {
            if (!json) {
                out.printf("Ambiguous job reference: %s%n", jobIdString);
            } else {
                JobDeployResponse jobDeployResponse = new JobDeployResponse(JobDeployResponse.Status.AMBIGUOUS_JOB_REFERENCE, null, null);
                out.printf(jobDeployResponse.toJsonString(), new Object[0]);
            }
            return 1;
        }
        JobId jobId = (JobId)Iterables.getOnlyElement(jobs.keySet());
        return this.runWithJobId(options, client, out, json, jobId);
    }

    protected abstract int runWithJobId(Namespace var1, HeliosClient var2, PrintStream var3, boolean var4, JobId var5) throws ExecutionException, InterruptedException, IOException;
}

