/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.collect.Lists;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.HostSelector;
import com.spotify.helios.common.protocol.CreateDeploymentGroupResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DeploymentGroupCreateCommand
extends ControlCommand {
    private final Argument nameArg;
    private final Argument hostSelectorsArg;
    private final Argument quietArg;

    public DeploymentGroupCreateCommand(Subparser parser) {
        super(parser);
        parser.help("create a deployment group");
        this.nameArg = parser.addArgument(new String[]{"name"}).required(true).help("Deployment group name");
        this.hostSelectorsArg = parser.addArgument(new String[]{"host_selectors"}).action((ArgumentAction)Arguments.append()).setDefault((Object)Lists.newArrayList()).nargs("+").help("Host selector expression. Hosts matching this expression will be part of the deployment-group. Multiple conditions can be specified, separated by spaces (as separate arguments). If multiple conditions are given, all must be fulfilled. Operators supported are =, !=, in and notin. Example: foo=bar baz!=qux");
        this.quietArg = parser.addArgument(new String[]{"-q"}).action((ArgumentAction)Arguments.storeTrue()).help("only print job id");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        CreateDeploymentGroupResponse status;
        String name = options.getString(this.nameArg.getDest());
        List<HostSelector> hostSelectors = Utils.parseHostSelectors(options, this.hostSelectorsArg);
        boolean quiet = options.getBoolean(this.quietArg.getDest());
        DeploymentGroup deploymentGroup = DeploymentGroup.newBuilder().setName(name).setHostSelectors(hostSelectors).build();
        if (!quiet && !json) {
            out.println("Creating deployment group: " + deploymentGroup.toJsonString());
        }
        if ((status = (CreateDeploymentGroupResponse)client.createDeploymentGroup(deploymentGroup).get()) == null) {
            throw new RuntimeException("The Helios master could not create a deployment group.");
        }
        if (status.getStatus() != CreateDeploymentGroupResponse.Status.CONFLICT) {
            out.println(status.toJsonString());
            return 0;
        }
        if (!quiet && !json) {
            out.println("Failed: " + status);
        } else if (json) {
            out.println(status.toJsonString());
        }
        return 1;
    }
}

