/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Table;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.HostSelector;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.DeploymentGroupStatusResponse;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DeploymentGroupStatusCommand
extends ControlCommand {
    private final Argument nameArg;
    private final Argument fullArg;

    public DeploymentGroupStatusCommand(Subparser parser) {
        super(parser);
        parser.help("Show deployment-group status");
        this.nameArg = parser.addArgument(new String[]{"name"}).required(true).help("Deployment group name");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full hostnames and job ids.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException {
        String name = options.getString(this.nameArg.getDest());
        boolean full = options.getBoolean(this.fullArg.getDest());
        return DeploymentGroupStatusCommand.run0(client, out, json, name, full);
    }

    static int run0(HeliosClient client, PrintStream out, boolean json, String name, boolean full) throws ExecutionException, InterruptedException {
        DeploymentGroupStatusResponse status = (DeploymentGroupStatusResponse)client.deploymentGroupStatus(name).get();
        if (status == null) {
            if (json) {
                HashMap output = Maps.newHashMap();
                output.put("status", "DEPLOYMENT_GROUP_NOT_FOUND");
                out.print(Json.asStringUnchecked((Object)output));
            } else {
                out.printf("Unknown deployment group: %s%n", name);
            }
            return 1;
        }
        if (json) {
            out.println(Json.asPrettyStringUnchecked((Object)status));
        } else {
            JobId jobId = status.getDeploymentGroup().getJobId();
            String error = status.getError();
            List hostSelectors = status.getDeploymentGroup().getHostSelectors();
            out.printf("Name: %s%n", name);
            out.printf("Job Id: %s%n", full ? jobId : (jobId == null ? null : jobId.toShortString()));
            out.printf("Status: %s%n", status.getStatus());
            out.printf("Host selectors:%n", new Object[0]);
            for (HostSelector hostSelector : hostSelectors) {
                out.printf("  %s%n", hostSelector.toPrettyString());
            }
            if (!Strings.isNullOrEmpty((String)error)) {
                out.printf("Error: %s%n", error);
            }
            out.printf("%n", new Object[0]);
            DeploymentGroupStatusCommand.printTable(out, jobId, status.getHostStatuses(), full);
        }
        return 0;
    }

    private static void printTable(PrintStream out, JobId jobId, List<DeploymentGroupStatusResponse.HostStatus> hosts, boolean full) {
        Table table = Output.table(out);
        table.row("HOST", "UP-TO-DATE", "JOB", "STATE");
        for (DeploymentGroupStatusResponse.HostStatus hostStatus : hosts) {
            boolean upToDate;
            String displayHostName = Output.formatHostname(full, hostStatus.getHost());
            boolean bl = upToDate = hostStatus.getJobId() != null && hostStatus.getJobId().equals((Object)jobId);
            String job = hostStatus.getJobId() == null ? "-" : (full ? hostStatus.getJobId().toString() : hostStatus.getJobId().toShortString());
            String state = hostStatus.getState() != null ? hostStatus.getState().toString() : "-";
            table.row(displayHostName, upToDate ? "X" : "", job, state);
        }
        table.print();
    }
}

